/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.query.BindableType;
import org.hibernate.query.spi.QueryParameterBindingTypeResolver;

public abstract class QueryParameterBindingTypeResolverImpl
implements QueryParameterBindingTypeResolver {
    @Override
    public <T> BindableType<T> resolveParameterBindType(Class<T> javaType) {
        return this.getMappingMetamodel().resolveQueryParameterType(javaType);
    }

    @Override
    public <T> BindableType<? extends T> resolveParameterBindType(T bindValue) {
        Class<?> clazz;
        if (bindValue == null) {
            return null;
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(bindValue);
        Class<?> c = clazz = lazyInitializer != null ? lazyInitializer.getPersistentClass() : bindValue.getClass();
        do {
            BindableType<Class<?>> type;
            if ((type = this.resolveParameterBindType((T)c)) == null) continue;
            return type;
        } while ((c = c.getSuperclass()) != Object.class);
        if (!clazz.isEnum() && Serializable.class.isAssignableFrom(clazz)) {
            return this.resolveParameterBindType((T)Serializable.class);
        }
        return null;
    }
}

