/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.loader.ast.internal.CompoundNaturalIdLoader;
import org.hibernate.loader.ast.internal.MultiNaturalIdLoaderStandard;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoader;
import org.hibernate.loader.ast.spi.NaturalIdLoader;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMetadata;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.AbstractNaturalIdMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class CompoundNaturalIdMapping
extends AbstractNaturalIdMapping
implements MappingType,
FetchableContainer {
    private final List<SingularAttributeMapping> attributes;
    private List<JdbcMapping> jdbcMappings;

    public CompoundNaturalIdMapping(EntityMappingType declaringType, List<SingularAttributeMapping> attributes, MappingModelCreationProcess creationProcess) {
        super(declaringType, CompoundNaturalIdMapping.isMutable(attributes));
        this.attributes = attributes;
        creationProcess.registerInitializationCallback("Determine compound natural-id JDBC mappings ( " + declaringType.getEntityName() + ")", () -> {
            ArrayList<JdbcMapping> jdbcMappings = new ArrayList<JdbcMapping>();
            attributes.forEach(attribute -> attribute.forEachJdbcType((index, jdbcMapping) -> jdbcMappings.add((JdbcMapping)jdbcMapping)));
            this.jdbcMappings = jdbcMappings;
            return true;
        });
    }

    private static boolean isMutable(List<SingularAttributeMapping> attributes) {
        for (int i = 0; i < attributes.size(); ++i) {
            SingularAttributeMapping attributeMapping = attributes.get(i);
            AttributeMetadata metadata = attributeMapping.getAttributeMetadata();
            if (metadata.isUpdatable()) continue;
            return false;
        }
        return true;
    }

    public Object[] extractNaturalIdFromEntityState(Object[] state) {
        if (state == null) {
            return null;
        }
        if (state.length == this.attributes.size()) {
            return state;
        }
        Object[] values = new Object[this.attributes.size()];
        for (int i = 0; i <= this.attributes.size() - 1; ++i) {
            SingularAttributeMapping attributeMapping = this.attributes.get(i);
            values[i] = state[attributeMapping.getStateArrayPosition()];
        }
        return values;
    }

    public Object[] extractNaturalIdFromEntity(Object entity) {
        Object[] values = new Object[this.attributes.size()];
        for (int i = 0; i < this.attributes.size(); ++i) {
            values[i] = this.attributes.get(i).getPropertyAccess().getGetter().get(entity);
        }
        return values;
    }

    public Object[] normalizeInput(Object incoming) {
        if (incoming instanceof Object[]) {
            return (Object[])incoming;
        }
        if (incoming instanceof Map) {
            Map valueMap = (Map)incoming;
            List<SingularAttributeMapping> attributes = this.getNaturalIdAttributes();
            Object[] values = new Object[attributes.size()];
            for (int i = 0; i < attributes.size(); ++i) {
                values[i] = valueMap.get(attributes.get(i).getAttributeName());
            }
            return values;
        }
        throw new UnsupportedMappingException("Do not know how to normalize compound natural-id value : " + incoming);
    }

    @Override
    public void validateInternalForm(Object naturalIdValue) {
        if (naturalIdValue == null) {
            return;
        }
        if (naturalIdValue instanceof Object[]) {
            Object[] values = (Object[])naturalIdValue;
            if (values.length != this.attributes.size()) {
                throw new IllegalArgumentException("Natural-id value [" + naturalIdValue + "] did not contain the expected number of elements [" + this.attributes.size() + "]");
            }
            return;
        }
        throw new IllegalArgumentException("Natural-id value [" + naturalIdValue + "] was not an array as expected");
    }

    @Override
    public int calculateHashCode(Object value) {
        if (value == null) {
            return 0;
        }
        Object[] values = (Object[])value;
        int hashcode = 0;
        for (int i = 0; i < this.attributes.size(); ++i) {
            Object o = values[i];
            if (o == null) continue;
            hashcode = 27 * hashcode + this.attributes.get(i).getExpressibleJavaType().extractHashCode(o);
        }
        return hashcode;
    }

    @Override
    public void verifyFlushState(Object id, Object[] currentState, Object[] loadedState, SharedSessionContractImplementor session) {
        if (this.isMutable()) {
            return;
        }
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityPersister persister = this.getDeclaringType().getEntityPersister();
        Object[] naturalId = this.extractNaturalIdFromEntityState(currentState);
        Object snapshot = loadedState == null ? persistenceContext.getNaturalIdSnapshot(id, persister) : persister.getNaturalIdMapping().extractNaturalIdFromEntityState(loadedState);
        Object[] previousNaturalId = (Object[])snapshot;
        assert (naturalId.length == this.getNaturalIdAttributes().size());
        assert (previousNaturalId.length == naturalId.length);
        for (int i = 0; i < this.getNaturalIdAttributes().size(); ++i) {
            Object previousValue;
            Object currentValue;
            SingularAttributeMapping attributeMapping = this.getNaturalIdAttributes().get(i);
            boolean updatable = attributeMapping.getAttributeMetadata().isUpdatable();
            if (updatable || attributeMapping.areEqual(currentValue = naturalId[i], previousValue = previousNaturalId[i], session)) continue;
            throw new HibernateException(String.format("An immutable attribute [%s] within compound natural identifier of entity %s was altered from `%s` to `%s`", attributeMapping.getAttributeName(), persister.getEntityName(), previousValue, currentValue));
        }
    }

    @Override
    public boolean areEqual(Object one, Object other, SharedSessionContractImplementor session) {
        return Arrays.equals((Object[])one, (Object[])other);
    }

    @Override
    public List<SingularAttributeMapping> getNaturalIdAttributes() {
        return this.attributes;
    }

    @Override
    public NaturalIdLoader<?> makeLoader(EntityMappingType entityDescriptor) {
        return new CompoundNaturalIdLoader(this, entityDescriptor);
    }

    @Override
    public MultiNaturalIdLoader<?> makeMultiLoader(EntityMappingType entityDescriptor) {
        return new MultiNaturalIdLoaderStandard(entityDescriptor);
    }

    @Override
    public MappingType getPartMappingType() {
        return this;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.getDeclaringType().getJavaType();
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.getJavaType();
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        for (AttributeMapping attributeMapping : this.attributes) {
            if (!attributeMapping.hasPartitionedSelectionMapping()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        assert (navigablePath.getLocalName().equals("{natural-id}"));
        SessionFactoryImplementor sessionFactory = creationState.getSqlAstCreationState().getCreationContext().getSessionFactory();
        JavaType<Object[]> jtd = sessionFactory.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object[].class));
        creationState.getSqlAstCreationState().getFromClauseAccess().resolveTableGroup(navigablePath, np -> tableGroup);
        return new DomainResultImpl(navigablePath, this, jtd, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            this.attributes.get(i).applySqlSelections(navigablePath, tableGroup, creationState);
        }
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            this.attributes.get(i).applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
        }
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        int span = 0;
        if (domainValue == null) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                span += this.attributes.get(i).breakDownJdbcValues(null, offset + span, x, y, valueConsumer, session);
            }
        } else {
            assert (domainValue instanceof Object[]);
            Object[] values = (Object[])domainValue;
            assert (values.length == this.attributes.size());
            for (int i = 0; i < this.attributes.size(); ++i) {
                span += this.attributes.get(i).breakDownJdbcValues(values[i], offset + span, x, y, valueConsumer, session);
            }
        }
        return span;
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        int span = 0;
        for (int i = 0; i < this.attributes.size(); ++i) {
            span += this.attributes.get(i).forEachSelectable(span + offset, consumer);
        }
        return span;
    }

    @Override
    public int getJdbcTypeCount() {
        return this.jdbcMappings.size();
    }

    @Override
    public List<JdbcMapping> getJdbcMappings() {
        return this.jdbcMappings;
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        return this.jdbcMappings.get(index);
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        int span;
        for (span = 0; span < this.jdbcMappings.size(); ++span) {
            action.accept(span + offset, this.jdbcMappings.get(span));
        }
        return span;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        assert (value instanceof Object[]);
        Object[] incoming = (Object[])value;
        assert (incoming.length == this.attributes.size());
        Object[] outgoing = new Object[incoming.length];
        for (int i = 0; i < this.attributes.size(); ++i) {
            SingularAttributeMapping attribute = this.attributes.get(i);
            outgoing[i] = attribute.disassemble(incoming[i], session);
        }
        return outgoing;
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        if (value == null) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                this.attributes.get(i).addToCacheKey(cacheKey, null, session);
            }
        } else {
            assert (value instanceof Object[]);
            Object[] values = (Object[])value;
            assert (values.length == this.attributes.size());
            for (int i = 0; i < this.attributes.size(); ++i) {
                this.attributes.get(i).addToCacheKey(cacheKey, values[i], session);
            }
        }
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        int span = 0;
        if (value == null) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                SingularAttributeMapping attribute = this.attributes.get(i);
                span += attribute.forEachDisassembledJdbcValue(null, span + offset, x, y, valuesConsumer, session);
            }
        } else {
            assert (value instanceof Object[]);
            Object[] incoming = (Object[])value;
            assert (incoming.length == this.attributes.size());
            for (int i = 0; i < this.attributes.size(); ++i) {
                SingularAttributeMapping attribute = this.attributes.get(i);
                span += attribute.forEachDisassembledJdbcValue(incoming[i], span + offset, x, y, valuesConsumer, session);
            }
        }
        return span;
    }

    @Override
    public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        int span = 0;
        if (value == null) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                SingularAttributeMapping attribute = this.attributes.get(i);
                span += attribute.forEachJdbcValue(null, span + offset, x, y, valuesConsumer, session);
            }
        } else {
            assert (value instanceof Object[]);
            Object[] incoming = (Object[])value;
            assert (incoming.length == this.attributes.size());
            for (int i = 0; i < this.attributes.size(); ++i) {
                SingularAttributeMapping attribute = this.attributes.get(i);
                span += attribute.forEachJdbcValue(incoming[i], span + offset, x, y, valuesConsumer, session);
            }
        }
        return span;
    }

    @Override
    public int getNumberOfFetchables() {
        return this.attributes.size();
    }

    @Override
    public Fetchable getFetchable(int position) {
        return this.attributes.get(position);
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!name.equals(this.attributes.get(i).getAttributeName())) continue;
            return this.attributes.get(i);
        }
        return null;
    }

    @Override
    public void forEachSubPart(IndexedConsumer<ModelPart> consumer, EntityMappingType treatTarget) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            consumer.accept(i, this.attributes.get(i));
        }
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        this.attributes.forEach(consumer);
    }

    private static class InitializerImpl
    implements FetchParentAccess {
        private final NavigablePath navigablePath;
        private final CompoundNaturalIdMapping naturalIdMapping;

        public InitializerImpl(NavigablePath navigablePath, CompoundNaturalIdMapping naturalIdMapping) {
            this.navigablePath = navigablePath;
            this.naturalIdMapping = naturalIdMapping;
        }

        @Override
        public FetchParentAccess findFirstEntityDescriptorAccess() {
            return null;
        }

        @Override
        public EntityInitializer findFirstEntityInitializer() {
            return null;
        }

        @Override
        public Object getParentKey() {
            return null;
        }

        @Override
        public NavigablePath getNavigablePath() {
            return this.navigablePath;
        }

        @Override
        public ModelPart getInitializedPart() {
            return this.naturalIdMapping;
        }

        @Override
        public Object getInitializedInstance() {
            return null;
        }

        @Override
        public void resolveKey(RowProcessingState rowProcessingState) {
        }

        @Override
        public void resolveInstance(RowProcessingState rowProcessingState) {
        }

        @Override
        public void initializeInstance(RowProcessingState rowProcessingState) {
        }

        @Override
        public void finishUpRow(RowProcessingState rowProcessingState) {
        }

        @Override
        public void registerResolutionListener(Consumer<Object> resolvedParentConsumer) {
        }
    }

    private static class AssemblerImpl
    implements DomainResultAssembler<Object[]> {
        private final JavaType<Object[]> jtd;
        private final DomainResultAssembler<?>[] subAssemblers;

        private AssemblerImpl(ImmutableFetchList fetches, NavigablePath navigablePath, CompoundNaturalIdMapping naturalIdMapping, JavaType<Object[]> jtd, AssemblerCreationState creationState) {
            this.jtd = jtd;
            InitializerImpl initializer = new InitializerImpl(navigablePath, naturalIdMapping);
            this.subAssemblers = new DomainResultAssembler[fetches.size()];
            int i = 0;
            for (Fetch fetch : fetches) {
                this.subAssemblers[i++] = fetch.createAssembler(initializer, creationState);
            }
        }

        @Override
        public Object[] assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
            Object[] result = new Object[this.subAssemblers.length];
            for (int i = 0; i < this.subAssemblers.length; ++i) {
                result[i] = this.subAssemblers[i].assemble(rowProcessingState, options);
            }
            return result;
        }

        @Override
        public JavaType<Object[]> getAssembledJavaType() {
            return this.jtd;
        }
    }

    public static class DomainResultImpl
    implements DomainResult<Object[]>,
    FetchParent {
        private final NavigablePath navigablePath;
        private final CompoundNaturalIdMapping naturalIdMapping;
        private final JavaType<Object[]> arrayJtd;
        private final ImmutableFetchList fetches;
        private final boolean hasJoinFetches;
        private final boolean containsCollectionFetches;
        private final String resultVariable;

        public DomainResultImpl(NavigablePath navigablePath, CompoundNaturalIdMapping naturalIdMapping, JavaType<Object[]> arrayJtd, String resultVariable, DomainResultCreationState creationState) {
            this.navigablePath = navigablePath;
            this.naturalIdMapping = naturalIdMapping;
            this.arrayJtd = arrayJtd;
            this.resultVariable = resultVariable;
            this.fetches = creationState.visitFetches(this);
            this.hasJoinFetches = this.fetches.hasJoinFetches();
            this.containsCollectionFetches = this.fetches.containsCollectionFetches();
        }

        @Override
        public String getResultVariable() {
            return this.resultVariable;
        }

        @Override
        public DomainResultAssembler<Object[]> createResultAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
            return new AssemblerImpl(this.fetches, this.navigablePath, this.naturalIdMapping, this.arrayJtd, creationState);
        }

        public JavaType<Object[]> getResultJavaType() {
            return this.arrayJtd;
        }

        @Override
        public FetchableContainer getReferencedMappingContainer() {
            return this.getReferencedMappingType();
        }

        @Override
        public FetchableContainer getReferencedMappingType() {
            return this.naturalIdMapping;
        }

        @Override
        public NavigablePath getNavigablePath() {
            return this.navigablePath;
        }

        @Override
        public ImmutableFetchList getFetches() {
            return this.fetches;
        }

        @Override
        public Fetch findFetch(Fetchable fetchable) {
            assert (fetchable != null);
            return this.fetches.get(fetchable);
        }

        @Override
        public boolean hasJoinFetches() {
            return this.hasJoinFetches;
        }

        @Override
        public boolean containsCollectionFetches() {
            return this.containsCollectionFetches;
        }
    }
}

