/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.remoting.RemotingEndpointAdd;
import org.jboss.as.remoting.RemotingEndpointRemove;
import org.jboss.as.remoting.RemotingExtension;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.io.OptionAttributeDefinition;

class RemotingEndpointResource
extends SimpleResourceDefinition {
    static final PathElement ENDPOINT_PATH = PathElement.pathElement((String)"configuration", (String)"endpoint");
    static final Map<String, AttributeDefinition> ATTRIBUTES;
    static final RemotingEndpointResource INSTANCE;

    private RemotingEndpointResource() {
        super(new SimpleResourceDefinition.Parameters(ENDPOINT_PATH, RemotingExtension.getResourceDescriptionResolver("endpoint")).setAddHandler((OperationStepHandler)new RemotingEndpointAdd()).setRemoveHandler((OperationStepHandler)new RemotingEndpointRemove()).setAddRestartLevel(OperationEntry.Flag.RESTART_ALL_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_ALL_SERVICES).setDeprecatedSince(ModelVersion.create((int)5)));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ToParentHandler toParentHandler = new ToParentHandler();
        for (AttributeDefinition ad : ATTRIBUTES.values()) {
            resourceRegistration.registerReadWriteAttribute(ad, (OperationStepHandler)toParentHandler, (OperationStepHandler)toParentHandler);
        }
    }

    static {
        INSTANCE = new RemotingEndpointResource();
        LinkedHashMap<String, Object> attrs = new LinkedHashMap<String, Object>();
        assert (RemotingSubsystemRootResource.WORKER.getName().equals(RemotingSubsystemRootResource.WORKER.getXmlName()));
        attrs.put(RemotingSubsystemRootResource.WORKER.getName(), RemotingSubsystemRootResource.WORKER);
        for (OptionAttributeDefinition ad : RemotingSubsystemRootResource.OPTIONS) {
            assert (ad.getName().equals(ad.getXmlName()));
            attrs.put(ad.getName(), ad);
        }
        ATTRIBUTES = Collections.unmodifiableMap(attrs);
    }

    private static class ToParentHandler
    implements OperationStepHandler {
        private ToParentHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress parent = context.getCurrentAddress().getParent();
            ModelNode parentOp = operation.clone();
            parentOp.get("address").set(parent.toModelNode());
            OperationStepHandler osh = context.getRootResourceRegistration().getOperationHandler(parent, operation.get("operation").asString());
            context.addStep(parentOp, osh, OperationContext.Stage.MODEL, true);
        }
    }
}

