/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import jakarta.resource.spi.work.WorkAdapter;
import jakarta.resource.spi.work.WorkEvent;
import org.jboss.jca.core.api.workmanager.StatisticsExecutor;
import org.jboss.jca.core.spi.workmanager.Address;
import org.jboss.jca.core.spi.workmanager.transport.Transport;

public class WorkEventListener
extends WorkAdapter {
    private boolean isLong;
    private StatisticsExecutor shortThreadPool;
    private StatisticsExecutor longThreadPool;
    private Address address;
    private Transport transport;

    public WorkEventListener(boolean isLong, StatisticsExecutor shortThreadPool, StatisticsExecutor longThreadPool, Address address, Transport transport) {
        this.isLong = isLong;
        this.shortThreadPool = shortThreadPool;
        this.longThreadPool = longThreadPool;
        this.address = address;
        this.transport = transport;
    }

    public void workCompleted(WorkEvent e) {
        this.done();
    }

    public void workRejected(WorkEvent e) {
        this.done();
    }

    private void done() {
        if (this.longThreadPool != null && this.isLong) {
            this.transport.updateLongRunningFree(this.address, this.longThreadPool.getNumberOfFreeThreads() + 1L);
        } else {
            this.transport.updateShortRunningFree(this.address, this.shortThreadPool.getNumberOfFreeThreads() + 1L);
        }
    }
}

