/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.jose.jwk;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.wildfly.common.Assert;
import org.wildfly.common.codec.Base64Alphabet;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.pem.Pem;

public class JWKUtil {
    public static final Base64Alphabet BASE64_URL = new Base64Alphabet(false){

        public int encode(int val) {
            if (val <= 25) {
                return 65 + val;
            }
            if (val <= 51) {
                return 97 + val - 26;
            }
            if (val <= 61) {
                return 48 + val - 52;
            }
            if (val == 62) {
                return 45;
            }
            assert (val == 63);
            return 95;
        }

        public int decode(int codePoint) throws IllegalArgumentException {
            if (65 <= codePoint && codePoint <= 90) {
                return codePoint - 65;
            }
            if (97 <= codePoint && codePoint <= 122) {
                return codePoint - 97 + 26;
            }
            if (48 <= codePoint && codePoint <= 57) {
                return codePoint - 48 + 52;
            }
            if (codePoint == 45) {
                return 62;
            }
            if (codePoint == 95) {
                return 63;
            }
            return -1;
        }
    };

    public static String base64UrlEncode(byte[] data) {
        return ByteIterator.ofBytes((byte[])data).base64Encode(BASE64_URL, false).drainToString();
    }

    public static byte[] base64UrlDecode(String data) {
        return CodePointIterator.ofString((String)data).base64Decode(BASE64_URL, false).drain();
    }

    public static String generateThumbprint(String[] certChain, String algorithm) throws NoSuchAlgorithmException {
        Assert.checkNotNullParam((String)"certChain", (Object)certChain);
        Assert.checkNotNullParam((String)"algorithm", (Object)algorithm);
        return ByteIterator.ofBytes((byte[])JWKUtil.generateThumbprintBytes(certChain, algorithm)).base64Encode(BASE64_URL, false).drainToString();
    }

    static byte[] generateThumbprintBytes(String[] certChain, String algorithm) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(algorithm).digest(Pem.extractDerContent((CodePointIterator)CodePointIterator.ofString((String)certChain[0])));
    }
}

