/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.factory;

import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.impl.factory.CacheBasedStrongCounterFactory;
import org.infinispan.counter.impl.factory.CacheBasedWeakCounterFactory;
import org.infinispan.counter.impl.factory.StrongCounterFactory;
import org.infinispan.counter.impl.factory.WeakCounterFactory;
import org.infinispan.counter.impl.listener.CounterManagerNotificationManager;
import org.infinispan.counter.impl.manager.CounterConfigurationManager;
import org.infinispan.counter.impl.manager.CounterConfigurationStorage;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.counter.impl.manager.PersistedCounterConfigurationStorage;
import org.infinispan.counter.impl.manager.VolatileCounterConfigurationStorage;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.impl.ComponentAlias;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.logging.Log;

@DefaultFactoryFor(classes={WeakCounterFactory.class, StrongCounterFactory.class, CounterManagerNotificationManager.class, CounterConfigurationManager.class, CounterConfigurationStorage.class, CounterManager.class, EmbeddedCounterManager.class})
@Scope(value=Scopes.GLOBAL)
public class CounterComponentsFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    public Object construct(String name) {
        if (name.equals(WeakCounterFactory.class.getName())) {
            return new CacheBasedWeakCounterFactory();
        }
        if (name.equals(StrongCounterFactory.class.getName())) {
            return new CacheBasedStrongCounterFactory();
        }
        if (name.equals(CounterManagerNotificationManager.class.getName())) {
            return new CounterManagerNotificationManager();
        }
        if (name.equals(CounterConfigurationManager.class.getName())) {
            return new CounterConfigurationManager(this.globalConfiguration);
        }
        if (name.equals(CounterManager.class.getName())) {
            return new EmbeddedCounterManager();
        }
        if (name.equals(EmbeddedCounterManager.class.getName())) {
            return ComponentAlias.of(CounterManager.class);
        }
        if (name.equals(CounterConfigurationStorage.class.getName())) {
            return this.globalConfiguration.globalState().enabled() ? new PersistedCounterConfigurationStorage(this.globalConfiguration) : VolatileCounterConfigurationStorage.INSTANCE;
        }
        throw Log.CONTAINER.factoryCannotConstructComponent(name);
    }
}

