/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.facelets.tag.BeanPropertyTagRule;
import com.sun.faces.facelets.tag.MetadataImpl;
import com.sun.faces.facelets.tag.MetadataTargetImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRule;
import jakarta.faces.view.facelets.MetaRuleset;
import jakarta.faces.view.facelets.Metadata;
import jakarta.faces.view.facelets.MetadataTarget;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagException;
import java.beans.IntrospectionException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MetaRulesetImpl
extends MetaRuleset {
    private static final Logger LOGGER = FacesLogger.FACELETS_META.getLogger();
    private static final Map<Class<?>, WeakReference<MetadataTarget>> metadata = Collections.synchronizedMap(new WeakHashMap());
    private final Tag tag;
    private final Class<?> type;
    private final Map<String, TagAttribute> attributes;
    private final List<Metadata> mappers;
    private final List<MetaRule> rules;
    private static final Metadata NONE = new Metadata(){

        public void applyMetadata(FaceletContext ctx, Object instance) {
        }
    };

    public MetaRulesetImpl(Tag tag, Class<?> type) {
        this.tag = tag;
        this.type = type;
        this.attributes = new HashMap<String, TagAttribute>();
        this.mappers = new ArrayList<Metadata>();
        this.rules = new ArrayList<MetaRule>();
        TagAttribute[] attrs = this.tag.getAttributes().getAll();
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i].getLocalName().equals("class")) {
                this.attributes.put("styleClass", attrs[i]);
                continue;
            }
            this.attributes.put(attrs[i].getLocalName(), attrs[i]);
        }
        this.rules.add(BeanPropertyTagRule.Instance);
    }

    public MetaRuleset ignore(String attribute) {
        Util.notNull("attribute", attribute);
        this.attributes.remove(attribute);
        return this;
    }

    public MetaRuleset alias(String attribute, String property) {
        Util.notNull("attribute", attribute);
        Util.notNull("property", property);
        TagAttribute attr = this.attributes.remove(attribute);
        if (attr != null) {
            this.attributes.put(property, attr);
        }
        return this;
    }

    public MetaRuleset add(Metadata mapper) {
        Util.notNull("mapper", mapper);
        if (!this.mappers.contains(mapper)) {
            this.mappers.add(mapper);
        }
        return this;
    }

    public MetaRuleset addRule(MetaRule rule) {
        Util.notNull("rule", rule);
        this.rules.add(rule);
        return this;
    }

    public Metadata finish() {
        if (!this.attributes.isEmpty()) {
            if (this.rules.isEmpty()) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    Iterator<TagAttribute> itr = this.attributes.values().iterator();
                    while (itr.hasNext()) {
                        LOGGER.severe(itr.next() + " Unhandled by MetaTagHandler for type " + this.type.getName());
                    }
                }
            } else {
                MetadataTarget target = this.getMetadataTarget();
                int ruleEnd = this.rules.size() - 1;
                for (Map.Entry<String, TagAttribute> entry : this.attributes.entrySet()) {
                    Metadata data = null;
                    for (int i = ruleEnd; data == null && i >= 0; --i) {
                        MetaRule rule = this.rules.get(i);
                        data = rule.applyRule(entry.getKey(), entry.getValue(), target);
                    }
                    if (data == null) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.severe(entry.getValue() + " Unhandled by MetaTagHandler for type " + this.type.getName());
                        continue;
                    }
                    this.mappers.add(data);
                }
            }
        }
        if (this.mappers.isEmpty()) {
            return NONE;
        }
        return new MetadataImpl(this.mappers.toArray(new Metadata[this.mappers.size()]));
    }

    public MetaRuleset ignoreAll() {
        this.attributes.clear();
        return this;
    }

    protected MetadataTarget getMetadataTarget() {
        MetadataTarget meta;
        WeakReference<MetadataTarget> metaRef = metadata.get(this.type);
        MetadataTarget metadataTarget = meta = metaRef == null ? null : (MetadataTarget)metaRef.get();
        if (meta == null) {
            try {
                meta = new MetadataTargetImpl(this.type);
            }
            catch (IntrospectionException e) {
                throw new TagException(this.tag, "Error Creating TargetMetadata", (Throwable)e);
            }
            metadata.put(this.type, new WeakReference<MetadataTarget>(meta));
        }
        return meta;
    }
}

