/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentResourceXMLDescriptionReader;
import org.jboss.as.controller.PersistentResourceXMLDescriptionWriter;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.service.SarSubsystemAdd;
import org.jboss.as.service.SarSubsystemSchema;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class SarExtension
implements Extension {
    public static final String NAMESPACE = "urn:jboss:domain:sar:1.0";
    public static final String SUBSYSTEM_NAME = "sar";
    private static final ParentResourceDescriptionResolver RESOLVER = new SubsystemResourceDescriptionResolver("sar", SarExtension.class);
    static final PathElement PATH = PathElement.pathElement((String)"subsystem", (String)"sar");
    static final String JMX_CAPABILITY = "org.wildfly.management.jmx";
    static final RuntimeCapability<Void> SAR_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.sar-deployment").addRequirements(new String[]{"org.wildfly.management.jmx"}).build();
    private static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)1, (int)0, (int)0);
    private final PersistentResourceXMLDescription currentDescription = SarSubsystemSchema.CURRENT.getXMLDescription();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        SimpleResourceDefinition definition = new SimpleResourceDefinition(new SimpleResourceDefinition.Parameters(PATH, (ResourceDescriptionResolver)RESOLVER).setAddHandler((OperationStepHandler)SarSubsystemAdd.INSTANCE).setRemoveHandler((OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).setCapabilities(new RuntimeCapability[]{SAR_CAPABILITY}));
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)definition);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)new PersistentResourceXMLDescriptionWriter(this.currentDescription));
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (SarSubsystemSchema schema : EnumSet.allOf(SarSubsystemSchema.class)) {
            SarSubsystemSchema reader = schema == SarSubsystemSchema.CURRENT ? new PersistentResourceXMLDescriptionReader(this.currentDescription) : schema;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespace().getUri(), (XMLElementReader)reader);
        }
    }
}

