/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.util.jdom;

import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.Text;

public class StaxSerializer {
    public void writeDocument(Document doc, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument("1.0");
        for (Content content : doc.getContent()) {
            if (!(content instanceof Element)) continue;
            this.writeElement((Element)content, writer);
        }
        writer.writeEndDocument();
    }

    public void writeElement(Element e, XMLStreamWriter writer) throws XMLStreamException {
        String elPrefix = e.getNamespacePrefix();
        String elUri = e.getNamespaceURI();
        String boundPrefix = writer.getPrefix(elUri);
        boolean writeElementNS = false;
        if (boundPrefix == null || !elPrefix.equals(boundPrefix)) {
            writeElementNS = true;
        }
        writer.writeStartElement(elPrefix, e.getName(), elUri);
        List namespaces = e.getAdditionalNamespaces();
        for (Namespace ns : namespaces) {
            String prefix = ns.getPrefix();
            String uri = ns.getURI();
            writer.setPrefix(prefix, uri);
            writer.writeNamespace(prefix, uri);
            if (!elUri.equals(uri) || !elPrefix.equals(prefix)) continue;
            writeElementNS = false;
        }
        for (Attribute attr : e.getAttributes()) {
            String attPrefix = attr.getNamespacePrefix();
            String attUri = attr.getNamespaceURI();
            if (attUri == null || attUri.isEmpty()) {
                writer.writeAttribute(attr.getName(), attr.getValue());
                continue;
            }
            writer.writeAttribute(attPrefix, attUri, attr.getName(), attr.getValue());
            if (this.isDeclared(writer, attPrefix, attUri)) continue;
            if (elUri.equals(attUri) && elPrefix.equals(attPrefix)) {
                if (!writeElementNS) continue;
                writer.setPrefix(attPrefix, attUri);
                writer.writeNamespace(attPrefix, attUri);
                writeElementNS = false;
                continue;
            }
            writer.setPrefix(attPrefix, attUri);
            writer.writeNamespace(attPrefix, attUri);
        }
        if (writeElementNS) {
            if (elPrefix == null || elPrefix.length() == 0) {
                writer.writeDefaultNamespace(elUri);
            } else {
                writer.writeNamespace(elPrefix, elUri);
            }
        }
        for (Content n : e.getContent()) {
            if (n instanceof CDATA) {
                writer.writeCData(n.getValue());
                continue;
            }
            if (n instanceof Text) {
                writer.writeCharacters(((Text)n).getText());
                continue;
            }
            if (n instanceof Element) {
                this.writeElement((Element)n, writer);
                continue;
            }
            if (n instanceof Comment) {
                writer.writeComment(n.getValue());
                continue;
            }
            if (!(n instanceof EntityRef)) continue;
        }
        writer.writeEndElement();
    }

    private boolean isDeclared(XMLStreamWriter writer, String prefix, String uri) throws XMLStreamException {
        Iterator<String> pxs = writer.getNamespaceContext().getPrefixes(uri);
        while (pxs.hasNext()) {
            String px = pxs.next();
            if (!px.equals(prefix)) continue;
            return true;
        }
        return false;
    }
}

