/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.Headers;
import jakarta.ejb.EJBHome;
import jakarta.ejb.NoSuchEJBException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.transaction.xa.XAException;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBMethodLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.CancelHandle;
import org.jboss.ejb.server.InvocationRequest;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.ElytronIdentityHandler;
import org.wildfly.httpclient.common.HttpMarshallerFactory;
import org.wildfly.httpclient.common.HttpServerHelper;
import org.wildfly.httpclient.common.HttpServiceConfig;
import org.wildfly.httpclient.common.NoFlushByteOutput;
import org.wildfly.httpclient.ejb.EjbConstants;
import org.wildfly.httpclient.ejb.EjbHttpClientMessages;
import org.wildfly.httpclient.ejb.HttpProtocolV1ObjectTable;
import org.wildfly.httpclient.ejb.InvocationIdentifier;
import org.wildfly.httpclient.ejb.PackedInteger;
import org.wildfly.httpclient.ejb.RemoteHTTPHandler;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransactionContext;

class HttpInvocationHandler
extends RemoteHTTPHandler {
    private final Association association;
    private final ExecutorService executorService;
    private final LocalTransactionContext localTransactionContext;
    private final Map<InvocationIdentifier, CancelHandle> cancellationFlags;
    private final Function<String, Boolean> classResolverFilter;
    private final HttpServiceConfig httpServiceConfig;

    HttpInvocationHandler(Association association, ExecutorService executorService, LocalTransactionContext localTransactionContext, Map<InvocationIdentifier, CancelHandle> cancellationFlags, Function<String, Boolean> classResolverFilter, HttpServiceConfig httpServiceConfig) {
        super(executorService);
        this.association = association;
        this.executorService = executorService;
        this.localTransactionContext = localTransactionContext;
        this.cancellationFlags = cancellationFlags;
        this.classResolverFilter = classResolverFilter;
        this.httpServiceConfig = httpServiceConfig;
    }

    @Override
    protected void handleInternal(final HttpServerExchange exchange) throws Exception {
        String[] parts;
        String ct = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        ContentType contentType = ContentType.parse((String)ct);
        if (contentType == null || contentType.getVersion() != 1 || !EjbConstants.INVOCATION.getType().equals(contentType.getType())) {
            exchange.setStatusCode(400);
            EjbHttpClientMessages.MESSAGES.debugf("Bad content type %s", ct);
            return;
        }
        String relativePath = exchange.getRelativePath();
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if ((parts = relativePath.split("/")).length < 7) {
            exchange.setStatusCode(404);
            return;
        }
        final String app = HttpInvocationHandler.handleDash(parts[0]);
        final String module = HttpInvocationHandler.handleDash(parts[1]);
        final String distinct = HttpInvocationHandler.handleDash(parts[2]);
        final String bean = parts[3];
        String originalSessionId = HttpInvocationHandler.handleDash(parts[4]);
        final byte[] sessionID = originalSessionId.isEmpty() ? null : Base64.getUrlDecoder().decode(originalSessionId);
        final String viewName = parts[5];
        final String method = parts[6];
        final String[] parameterTypeNames = new String[parts.length - 7];
        System.arraycopy(parts, 7, parameterTypeNames, 0, parameterTypeNames.length);
        Cookie cookie = (Cookie)exchange.getRequestCookies().get("JSESSIONID");
        final String sessionAffinity = cookie != null ? cookie.getValue() : null;
        final EJBIdentifier ejbIdentifier = new EJBIdentifier(app, module, bean, distinct);
        String cancellationId = exchange.getRequestHeaders().getFirst(EjbConstants.INVOCATION_ID);
        final InvocationIdentifier identifier = cancellationId != null && sessionAffinity != null ? new InvocationIdentifier(cancellationId, sessionAffinity) : null;
        exchange.dispatch((Executor)this.executorService, () -> {
            CancelHandle handle = this.association.receiveInvocationRequest(new InvocationRequest(){

                public SocketAddress getPeerAddress() {
                    return exchange.getSourceAddress();
                }

                public SocketAddress getLocalAddress() {
                    return exchange.getDestinationAddress();
                }

                public InvocationRequest.Resolved getRequestContent(ClassLoader classLoader) throws IOException, ClassNotFoundException {
                    ResolvedInvocation resolvedInvocation;
                    block17: {
                        Object[] methodParams = new Object[parameterTypeNames.length];
                        Class<?> view = Class.forName(viewName, false, classLoader);
                        HttpMarshallerFactory unmarshallingFactory = HttpInvocationHandler.this.httpServiceConfig.getHttpUnmarshallerFactory(exchange);
                        Unmarshaller unmarshaller = unmarshallingFactory.createUnmarshaller((ClassResolver)new FilteringClassResolver(classLoader, HttpInvocationHandler.this.classResolverFilter), (ObjectTable)HttpProtocolV1ObjectTable.INSTANCE);
                        InputStream inputStream = exchange.getInputStream();
                        try {
                            HashMap<String, Object> contextData;
                            Transaction transaction;
                            unmarshaller.start((ByteInput)new InputStreamByteInput(inputStream));
                            RemoteHTTPHandler.ReceivedTransaction txConfig = HttpInvocationHandler.this.readTransaction(unmarshaller);
                            if (txConfig == null || HttpInvocationHandler.this.localTransactionContext == null) {
                                transaction = null;
                            } else {
                                try {
                                    ImportResult result = HttpInvocationHandler.this.localTransactionContext.findOrImportTransaction(txConfig.getXid(), txConfig.getRemainingTime());
                                    transaction = result.getTransaction();
                                }
                                catch (XAException e) {
                                    throw new IllegalStateException(e);
                                }
                            }
                            for (int i = 0; i < parameterTypeNames.length; ++i) {
                                methodParams[i] = unmarshaller.readObject();
                            }
                            int attachmentCount = PackedInteger.readPackedInteger((DataInput)unmarshaller);
                            if (attachmentCount > 0) {
                                contextData = new HashMap<String, Object>();
                                for (int i = 0; i < attachmentCount; ++i) {
                                    Object o = unmarshaller.readObject();
                                    String key = (String)o;
                                    Object value = unmarshaller.readObject();
                                    contextData.put(key, value);
                                }
                            } else {
                                contextData = new HashMap();
                            }
                            contextData.put("jboss.source-address", exchange.getConnection().getPeerAddress());
                            unmarshaller.finish();
                            Object locator = EJBHome.class.isAssignableFrom(view) ? new EJBHomeLocator(view, app, module, bean, distinct, Affinity.LOCAL) : (sessionID != null ? new StatefulEJBLocator(view, app, module, bean, distinct, SessionID.createSessionID((byte[])sessionID), Affinity.LOCAL) : new StatelessEJBLocator(view, app, module, bean, distinct, Affinity.LOCAL));
                            HttpMarshallerFactory marshallerFactory = HttpInvocationHandler.this.httpServiceConfig.getHttpMarshallerFactory(exchange);
                            Marshaller marshaller = marshallerFactory.createMarshaller((ClassResolver)new FilteringClassResolver(classLoader, HttpInvocationHandler.this.classResolverFilter), (ObjectTable)HttpProtocolV1ObjectTable.INSTANCE);
                            resolvedInvocation = new ResolvedInvocation((Map<String, Object>)contextData, methodParams, (EJBLocator<?>)locator, exchange, marshaller, sessionAffinity, transaction, identifier);
                            if (inputStream == null) break block17;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException | ClassNotFoundException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                throw new IOException(e);
                            }
                        }
                        inputStream.close();
                    }
                    return resolvedInvocation;
                }

                public EJBMethodLocator getMethodLocator() {
                    return new EJBMethodLocator(method, parameterTypeNames);
                }

                public void writeNoSuchMethod() {
                    if (identifier != null) {
                        HttpInvocationHandler.this.cancellationFlags.remove(identifier);
                    }
                    HttpServerHelper.sendException((HttpServerExchange)exchange, (HttpServiceConfig)HttpInvocationHandler.this.httpServiceConfig, (int)404, (Throwable)EjbHttpClientMessages.MESSAGES.noSuchMethod());
                }

                public void writeSessionNotActive() {
                    if (identifier != null) {
                        HttpInvocationHandler.this.cancellationFlags.remove(identifier);
                    }
                    HttpServerHelper.sendException((HttpServerExchange)exchange, (HttpServiceConfig)HttpInvocationHandler.this.httpServiceConfig, (int)500, (Throwable)EjbHttpClientMessages.MESSAGES.sessionNotActive());
                }

                public void writeWrongViewType() {
                    if (identifier != null) {
                        HttpInvocationHandler.this.cancellationFlags.remove(identifier);
                    }
                    HttpServerHelper.sendException((HttpServerExchange)exchange, (HttpServiceConfig)HttpInvocationHandler.this.httpServiceConfig, (int)404, (Throwable)EjbHttpClientMessages.MESSAGES.wrongViewType());
                }

                public Executor getRequestExecutor() {
                    return HttpInvocationHandler.this.executorService == null ? exchange.getIoThread().getWorker() : HttpInvocationHandler.this.executorService;
                }

                public String getProtocol() {
                    return exchange.getProtocol().toString();
                }

                public boolean isBlockingCaller() {
                    return false;
                }

                public EJBIdentifier getEJBIdentifier() {
                    return ejbIdentifier;
                }

                public SecurityIdentity getSecurityIdentity() {
                    return (SecurityIdentity)exchange.getAttachment(ElytronIdentityHandler.IDENTITY_KEY);
                }

                public void writeException(@NotNull Exception exception) {
                    if (identifier != null) {
                        HttpInvocationHandler.this.cancellationFlags.remove(identifier);
                    }
                    HttpServerHelper.sendException((HttpServerExchange)exchange, (HttpServiceConfig)HttpInvocationHandler.this.httpServiceConfig, (int)500, (Throwable)exception);
                }

                public void writeNoSuchEJB() {
                    if (identifier != null) {
                        HttpInvocationHandler.this.cancellationFlags.remove(identifier);
                    }
                    HttpServerHelper.sendException((HttpServerExchange)exchange, (HttpServiceConfig)HttpInvocationHandler.this.httpServiceConfig, (int)404, (Throwable)new NoSuchEJBException());
                }

                public void writeCancelResponse() {
                    if (identifier != null) {
                        HttpInvocationHandler.this.cancellationFlags.remove(identifier);
                    }
                }

                public void writeNotStateful() {
                    if (identifier != null) {
                        HttpInvocationHandler.this.cancellationFlags.remove(identifier);
                    }
                    HttpServerHelper.sendException((HttpServerExchange)exchange, (HttpServiceConfig)HttpInvocationHandler.this.httpServiceConfig, (int)500, (Throwable)EjbHttpClientMessages.MESSAGES.notStateful());
                }

                public void convertToStateful(@NotNull SessionID sessionId) throws IllegalArgumentException, IllegalStateException {
                    throw new RuntimeException("nyi");
                }
            });
            if (handle != null && identifier != null) {
                this.cancellationFlags.put(identifier, handle);
            }
        });
    }

    private static String handleDash(String s) {
        if (s.equals("-")) {
            return "";
        }
        return s;
    }

    private static class FilteringClassResolver
    extends SimpleClassResolver {
        private final Function<String, Boolean> classResolverFilter;

        FilteringClassResolver(ClassLoader classLoader, Function<String, Boolean> classResolverFilter) {
            super(classLoader);
            this.classResolverFilter = classResolverFilter;
        }

        public Class<?> resolveClass(Unmarshaller unmarshaller, String name, long serialVersionUID) throws IOException, ClassNotFoundException {
            this.checkFilter(name);
            return super.resolveClass(unmarshaller, name, serialVersionUID);
        }

        public Class<?> resolveProxyClass(Unmarshaller unmarshaller, String[] interfaces) throws IOException, ClassNotFoundException {
            for (String name : interfaces) {
                this.checkFilter(name);
            }
            return super.resolveProxyClass(unmarshaller, interfaces);
        }

        private void checkFilter(String className) throws InvalidClassException {
            if (this.classResolverFilter != null && this.classResolverFilter.apply(className) != Boolean.TRUE) {
                throw EjbHttpClientMessages.MESSAGES.cannotResolveFilteredClass(className);
            }
        }
    }

    class ResolvedInvocation
    implements InvocationRequest.Resolved {
        private final Map<String, Object> contextData;
        private final Object[] methodParams;
        private final EJBLocator<?> locator;
        private final HttpServerExchange exchange;
        private final Marshaller marshaller;
        private final String sessionAffinity;
        private final Transaction transaction;
        private final InvocationIdentifier identifier;

        public ResolvedInvocation(Map<String, Object> contextData, Object[] methodParams, EJBLocator<?> locator, HttpServerExchange exchange, Marshaller marshaller, String sessionAffinity, Transaction transaction, InvocationIdentifier identifier) {
            this.contextData = contextData;
            this.methodParams = methodParams;
            this.locator = locator;
            this.exchange = exchange;
            this.marshaller = marshaller;
            this.sessionAffinity = sessionAffinity;
            this.transaction = transaction;
            this.identifier = identifier;
        }

        public Map<String, Object> getAttachments() {
            return this.contextData;
        }

        public Object[] getParameters() {
            return this.methodParams;
        }

        public EJBLocator<?> getEJBLocator() {
            return this.locator;
        }

        public boolean hasTransaction() {
            return this.transaction != null;
        }

        public Transaction getTransaction() throws SystemException, IllegalStateException {
            return this.transaction;
        }

        String getSessionAffinity() {
            return this.sessionAffinity;
        }

        HttpServerExchange getExchange() {
            return this.exchange;
        }

        public void writeInvocationResult(Object result) {
            if (this.identifier != null) {
                HttpInvocationHandler.this.cancellationFlags.remove(this.identifier);
            }
            try {
                this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, EjbConstants.EJB_RESPONSE.toString());
                OutputStream outputStream = this.exchange.getOutputStream();
                NoFlushByteOutput byteOutput = new NoFlushByteOutput(Marshalling.createByteOutput((OutputStream)outputStream));
                this.marshaller.start((ByteOutput)byteOutput);
                this.marshaller.writeObject(result);
                PackedInteger.writePackedInteger((DataOutput)this.marshaller, this.contextData.size());
                for (Map.Entry<String, Object> entry : this.contextData.entrySet()) {
                    this.marshaller.writeObject((Object)entry.getKey());
                    this.marshaller.writeObject(entry.getValue());
                }
                this.marshaller.finish();
                this.marshaller.flush();
                this.exchange.endExchange();
            }
            catch (Exception e) {
                HttpServerHelper.sendException((HttpServerExchange)this.exchange, (HttpServiceConfig)HttpInvocationHandler.this.httpServiceConfig, (int)500, (Throwable)e);
            }
        }
    }
}

