/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.patching.DirectoryStructure;
import org.jboss.as.patching.installation.AddOn;
import org.jboss.as.patching.installation.Identity;
import org.jboss.as.patching.installation.InstallationModificationImpl;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.InstalledImage;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.installation.LayerInfo;
import org.jboss.as.patching.installation.MutableTargetImpl;
import org.jboss.as.patching.installation.PatchableTarget;

public class InstalledIdentityImpl
extends InstalledIdentity {
    private Identity identity;
    private final InstalledImage installedImage;
    private List<String> allPatches;
    private Map<String, Layer> layers = new LinkedHashMap<String, Layer>();
    private Map<String, AddOn> addOns = new LinkedHashMap<String, AddOn>();

    protected InstalledIdentityImpl(Identity identity, List<String> allPatches, InstalledImage installedImage) {
        this.identity = identity;
        this.installedImage = installedImage;
        this.allPatches = Collections.unmodifiableList(allPatches);
    }

    @Override
    public List<String> getAllInstalledPatches() {
        return this.allPatches;
    }

    @Override
    public Identity getIdentity() {
        return this.identity;
    }

    @Override
    public List<Layer> getLayers() {
        ArrayList<Layer> layers = new ArrayList<Layer>(this.layers.values());
        return Collections.unmodifiableList(layers);
    }

    @Override
    public List<String> getLayerNames() {
        ArrayList<String> layerNames = new ArrayList<String>(this.layers.keySet());
        return Collections.unmodifiableList(layerNames);
    }

    @Override
    public Layer getLayer(String layerName) {
        return this.layers.get(layerName);
    }

    @Override
    public Collection<String> getAddOnNames() {
        return Collections.unmodifiableCollection(this.addOns.keySet());
    }

    @Override
    public AddOn getAddOn(String addOnName) {
        return this.addOns.get(addOnName);
    }

    @Override
    public Collection<AddOn> getAddOns() {
        return Collections.unmodifiableCollection(this.addOns.values());
    }

    @Override
    public InstalledImage getInstalledImage() {
        return this.installedImage;
    }

    protected Layer putLayer(String name, Layer layer) {
        return this.layers.put(name, layer);
    }

    protected AddOn putAddOn(String name, AddOn addOn) {
        return this.addOns.put(name, addOn);
    }

    @Override
    protected void updateState(final String name, final InstallationModificationImpl modification, InstallationModificationImpl.InstallationState state) {
        MutableTargetImpl target;
        final PatchableTarget.TargetInfo identityInfo = modification.getModifiedState();
        this.identity = new Identity(){

            @Override
            public String getVersion() {
                return modification.getVersion();
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public PatchableTarget.TargetInfo loadTargetInfo() throws IOException {
                return identityInfo;
            }

            @Override
            public DirectoryStructure getDirectoryStructure() {
                return modification.getDirectoryStructure();
            }
        };
        this.allPatches = Collections.unmodifiableList(modification.getAllPatches());
        this.layers.clear();
        for (Map.Entry<String, MutableTargetImpl> entry : state.getLayers().entrySet()) {
            String layerName = entry.getKey();
            target = entry.getValue();
            this.putLayer(layerName, new LayerInfo(layerName, target.getModifiedState(), target.getDirectoryStructure()));
        }
        this.addOns.clear();
        for (Map.Entry<String, MutableTargetImpl> entry : state.getAddOns().entrySet()) {
            String addOnName = entry.getKey();
            target = entry.getValue();
            this.putAddOn(addOnName, new LayerInfo(addOnName, target.getModifiedState(), target.getDirectoryStructure()));
        }
    }
}

