/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.function.Supplier;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryOptions;

public class SqmInterpretationsKey
implements QueryInterpretationCache.Key {
    private final String query;
    private final Class<?> resultType;
    private final LockOptions lockOptions;
    private final TupleTransformer<?> tupleTransformer;
    private final ResultListTransformer resultListTransformer;

    public static SqmInterpretationsKey createInterpretationsKey(InterpretationsKeySource keySource) {
        if (!SqmInterpretationsKey.isCacheable(keySource)) {
            return null;
        }
        return new SqmInterpretationsKey(keySource.getQueryString(), keySource.getResultType(), keySource.getQueryOptions().getLockOptions(), keySource.getQueryOptions().getTupleTransformer(), keySource.getQueryOptions().getResultListTransformer());
    }

    private static boolean isCacheable(InterpretationsKeySource keySource) {
        assert (keySource.getQueryOptions().getAppliedGraph() != null);
        if ("<criteria>".equals(keySource.getQueryString())) {
            return false;
        }
        if (keySource.getLoadQueryInfluencers().hasEnabledFilters()) {
            return false;
        }
        if (keySource.getQueryOptions().getAppliedGraph().getSemantic() != null) {
            return false;
        }
        return keySource.hasMultiValuedParameterBindingsChecker().get() != Boolean.TRUE;
    }

    public static QueryInterpretationCache.Key generateNonSelectKey(InterpretationsKeySource keyDetails) {
        return null;
    }

    private SqmInterpretationsKey(String query, Class<?> resultType, LockOptions lockOptions, TupleTransformer<?> tupleTransformer, ResultListTransformer resultListTransformer) {
        this.query = query;
        this.resultType = resultType;
        this.lockOptions = lockOptions;
        this.tupleTransformer = tupleTransformer;
        this.resultListTransformer = resultListTransformer;
    }

    @Override
    public QueryInterpretationCache.Key prepareForStore() {
        return new SqmInterpretationsKey(this.query, this.resultType, this.lockOptions.makeCopy(), this.tupleTransformer, this.resultListTransformer);
    }

    @Override
    public String getQueryString() {
        return this.query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqmInterpretationsKey that = (SqmInterpretationsKey)o;
        return this.query.equals(that.query) && this.areEqual(this.resultType, that.resultType) && this.areEqual(this.lockOptions, that.lockOptions) && this.areEqual(this.tupleTransformer, that.tupleTransformer) && this.areEqual(this.resultListTransformer, that.resultListTransformer);
    }

    private <T> boolean areEqual(T o1, T o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    public static interface InterpretationsKeySource
    extends CacheabilityInfluencers {
        public Class<?> getResultType();
    }

    public static interface CacheabilityInfluencers {
        public String getQueryString();

        public QueryOptions getQueryOptions();

        public LoadQueryInfluencers getLoadQueryInfluencers();

        public Supplier<Boolean> hasMultiValuedParameterBindingsChecker();
    }
}

