/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.el;

import com.sun.faces.el.ELUtils;
import com.sun.faces.facelets.el.ContextualCompositeValueExpression;
import com.sun.faces.util.HtmlUtils;
import com.sun.faces.util.MessageUtils;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.view.Location;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class ELText {
    protected final String literal;

    public ELText(String literal) {
        this.literal = literal;
    }

    public boolean isLiteral() {
        return true;
    }

    public ELText apply(ExpressionFactory factory, ELContext ctx) {
        return this;
    }

    public void write(Writer out, ELContext ctx) throws ELException, IOException {
        out.write(this.literal);
    }

    public void writeText(ResponseWriter out, ELContext ctx) throws ELException, IOException {
        out.writeText((Object)this.literal, null);
    }

    public String toString(ELContext ctx) throws ELException {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static boolean isLiteral(String in) {
        ELText txt = ELText.parse(in);
        return txt == null || txt.isLiteral();
    }

    public static ELText parse(String in) throws ELException {
        return ELText.parse(null, null, in);
    }

    public static ELText parse(String in, String alias) throws ELException {
        return ELText.parse(null, null, in, alias);
    }

    public static ELText parse(ExpressionFactory fact, ELContext ctx, String in) throws ELException {
        return ELText.parse(null, null, in, null);
    }

    public static ELText parse(ExpressionFactory fact, ELContext ctx, String in, String alias) throws ELException {
        char[] ca = in.toCharArray();
        int i = 0;
        char c = '\u0000';
        int len = ca.length;
        int end = len - 1;
        boolean esc = false;
        int vlen = 0;
        StringBuffer buff = new StringBuffer(128);
        ArrayList<ELText> text = new ArrayList<ELText>();
        ELTextVariable t = null;
        ValueExpression ve = null;
        while (i < len) {
            c = ca[i];
            if ('\\' == c) {
                boolean bl = esc = !esc;
                if (esc && i < end && (ca[i + 1] == '$' || ca[i + 1] == '#')) {
                    ++i;
                    continue;
                }
            } else if (!(esc || '$' != c && '#' != c || i >= end || '{' != ca[i + 1])) {
                if (buff.length() > 0) {
                    text.add(new ELText(buff.toString()));
                    buff.setLength(0);
                }
                vlen = ELText.findVarLength(ca, i);
                if (ctx != null && fact != null) {
                    ve = fact.createValueExpression(ctx, new String(ca, i, vlen), String.class);
                    t = new ELTextVariable(ve);
                } else {
                    String expr = new String(ca, i, vlen);
                    if (null != alias && ELUtils.isCompositeComponentExpr(expr)) {
                        if (ELUtils.isCompositeComponentLookupWithArgs(expr)) {
                            String message = MessageUtils.getExceptionMessageString("com.sun.faces.ARGUMENTS_NOT_LEGAL_WITH_CC_ATTRS_EXPR", new Object[0]);
                            throw new ELException(message);
                        }
                        FacesContext context = FacesContext.getCurrentInstance();
                        ELContext elContext = context.getELContext();
                        ValueExpression delegate = context.getApplication().getExpressionFactory().createValueExpression(elContext, expr, Object.class);
                        Location location = new Location(alias, -1, -1);
                        ve = new ContextualCompositeValueExpression(location, delegate);
                    } else {
                        ve = new LiteralValueExpression(expr);
                    }
                    t = new ELTextVariable(ve);
                }
                text.add(t);
                i += vlen;
                continue;
            }
            esc = false;
            buff.append(c);
            ++i;
        }
        if (buff.length() > 0) {
            text.add(new ELText(buff.toString()));
            buff.setLength(0);
        }
        if (text.isEmpty()) {
            return new ELText("");
        }
        if (text.size() == 1) {
            return (ELText)text.get(0);
        }
        ELText[] ta = text.toArray(new ELText[text.size()]);
        return new ELTextComposite(ta);
    }

    private static int findVarLength(char[] ca, int s) throws ELException {
        int i;
        int len = ca.length;
        char c = '\u0000';
        char str = '\u0000';
        int nested = 0;
        boolean insideString = false;
        for (i = s; i < len; ++i) {
            c = ca[i];
            if ('\\' == c && i < len - 1) {
                ++i;
                continue;
            }
            if ('\'' == c || '\"' == c) {
                if (str == c) {
                    insideString = false;
                    str = '\u0000';
                    continue;
                }
                insideString = true;
                str = c;
                continue;
            }
            if ('{' == c && !insideString) {
                ++nested;
                continue;
            }
            if (str == '\u0000' && '}' == c) {
                if (nested > 1) {
                    --nested;
                    continue;
                }
                return i - s + 1;
            }
            if ('}' != c || insideString) continue;
            --nested;
        }
        throw new ELException("EL Expression Unbalanced: ... " + new String(ca, s, i - s));
    }

    private static final class ELTextVariable
    extends ELText {
        private final ValueExpression ve;

        public ELTextVariable(ValueExpression ve) {
            super(ve.getExpressionString());
            this.ve = ve;
        }

        @Override
        public boolean isLiteral() {
            return false;
        }

        @Override
        public ELText apply(ExpressionFactory factory, ELContext ctx) {
            ELTextVariable result = null;
            result = this.ve instanceof ContextualCompositeValueExpression ? new ELTextVariable(this.ve) : new ELTextVariable(factory.createValueExpression(ctx, this.ve.getExpressionString(), String.class));
            return result;
        }

        @Override
        public void write(Writer out, ELContext ctx) throws ELException, IOException {
            Object v = this.ve.getValue(ctx);
            if (v != null) {
                char[] buffer = new char[1028];
                HtmlUtils.writeTextForXML(out, v.toString(), buffer);
            }
        }

        @Override
        public String toString(ELContext ctx) throws ELException {
            Object v = this.ve.getValue(ctx);
            if (v != null) {
                return v.toString();
            }
            return null;
        }

        @Override
        public void writeText(ResponseWriter out, ELContext ctx) throws ELException, IOException {
            Object v = this.ve.getValue(ctx);
            if (v != null) {
                out.writeText((Object)v.toString(), null);
            }
        }
    }

    private static final class LiteralValueExpression
    extends ValueExpression {
        private static final long serialVersionUID = 1L;
        private final String text;

        public LiteralValueExpression(String text) {
            this.text = text;
        }

        public boolean isLiteralText() {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public String getExpressionString() {
            return this.text;
        }

        public boolean equals(Object obj) {
            return false;
        }

        public void setValue(ELContext context, Object value) {
        }

        public boolean isReadOnly(ELContext context) {
            return false;
        }

        public <T> T getValue(ELContext context) {
            return null;
        }

        public Class getType(ELContext context) {
            return null;
        }

        public Class getExpectedType() {
            return null;
        }
    }

    private static final class ELTextComposite
    extends ELText {
        private final ELText[] txt;

        public ELTextComposite(ELText[] txt) {
            super(null);
            this.txt = txt;
        }

        @Override
        public void write(Writer out, ELContext ctx) throws ELException, IOException {
            for (int i = 0; i < this.txt.length; ++i) {
                this.txt[i].write(out, ctx);
            }
        }

        @Override
        public void writeText(ResponseWriter out, ELContext ctx) throws ELException, IOException {
            for (int i = 0; i < this.txt.length; ++i) {
                this.txt[i].writeText(out, ctx);
            }
        }

        @Override
        public String toString(ELContext ctx) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.txt.length; ++i) {
                sb.append(this.txt[i].toString(ctx));
            }
            return sb.toString();
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.txt.length; ++i) {
                sb.append(this.txt[i].toString());
            }
            return sb.toString();
        }

        @Override
        public boolean isLiteral() {
            return false;
        }

        @Override
        public ELText apply(ExpressionFactory factory, ELContext ctx) {
            int len = this.txt.length;
            ELText[] nt = new ELText[len];
            for (int i = 0; i < len; ++i) {
                nt[i] = this.txt[i].apply(factory, ctx);
            }
            return new ELTextComposite(nt);
        }
    }
}

