/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.realm.token.TokenSecurityRealm;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.realm.token.validator.JwtValidator;
import org.wildfly.security.auth.realm.token.validator.OAuth2IntrospectValidator;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.pem.Pem;
import org.wildfly.security.pem.PemEntry;

class TokenRealmDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition PRINCIPAL_CLAIM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("principal-claim", ModelType.STRING, true).setDefaultValue(new ModelNode("username"))).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    protected static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-ssl-context", ModelType.STRING, true).setCapabilityReference("org.wildfly.security.ssl-context", "org.wildfly.security.security-realm")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).build();
    static final SimpleAttributeDefinition HOSTNAME_VERIFICATION_POLICY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("host-name-verification-policy", ModelType.STRING, true).setValidator((ParameterValidator)EnumValidator.create(OAuth2IntrospectionValidatorAttributes.HostnameVerificationPolicy.class))).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PRINCIPAL_CLAIM, JwtValidatorAttributes.JWT_VALIDATOR, OAuth2IntrospectionValidatorAttributes.OAUTH2_INTROSPECTION_VALIDATOR};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);

    TokenRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"token-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("token-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ElytronReloadRequiredWriteAttributeHandler handler = new ElytronReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
        }
    }

    private static class URLValidator
    extends StringLengthValidator {
        private URLValidator() {
            super(1, false, false);
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            String url = value.asString();
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.invalidURL(url, e);
            }
        }
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(new HashSet<RuntimeCapability>(Arrays.asList(Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY)), ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            String address = context.getCurrentAddressValue();
            ServiceName mainServiceName = Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
            ServiceName aliasServiceName = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
            final ModelNode principalClaimNode = PRINCIPAL_CLAIM.resolveModelAttribute(context, operation);
            if (operation.hasDefined("jwt")) {
                Set kids;
                ModelNode jwtValidatorNode = JwtValidatorAttributes.JWT_VALIDATOR.resolveModelAttribute(context, operation);
                final String[] issuer = this.asStringArrayIfDefined(context, JwtValidatorAttributes.ISSUER, jwtValidatorNode);
                final String[] audience = this.asStringArrayIfDefined(context, JwtValidatorAttributes.AUDIENCE, jwtValidatorNode);
                final String publicKey = JwtValidatorAttributes.PUBLIC_KEY.resolveModelAttribute(context, jwtValidatorNode).asStringOrNull();
                final InjectedValue keyStoreInjector = new InjectedValue();
                final String keyStoreName = JwtValidatorAttributes.KEY_STORE.resolveModelAttribute(context, jwtValidatorNode).asStringOrNull();
                final String certificateAlias = JwtValidatorAttributes.CERTIFICATE.resolveModelAttribute(context, jwtValidatorNode).asStringOrNull();
                final String sslContextRef = SSL_CONTEXT.resolveModelAttribute(context, jwtValidatorNode).asStringOrNull();
                final String hostNameVerificationPolicy = HOSTNAME_VERIFICATION_POLICY.resolveModelAttribute(context, jwtValidatorNode).asStringOrNull();
                final InjectedValue sslContextInjector = new InjectedValue();
                ModelNode keyMap = JwtValidatorAttributes.KEY_MAP.resolveModelAttribute(context, jwtValidatorNode);
                final LinkedHashMap<String, PublicKey> namedKeys = new LinkedHashMap<String, PublicKey>();
                if (keyMap.isDefined() && !(kids = keyMap.keys()).isEmpty()) {
                    for (String kid : kids) {
                        byte[] pemKey = keyMap.get(kid).asString().getBytes(StandardCharsets.UTF_8);
                        Iterator pemEntryIterator = Pem.parsePemContent((CodePointIterator)CodePointIterator.ofUtf8Bytes((byte[])pemKey));
                        PublicKey namedPublicKey = null;
                        try {
                            namedPublicKey = (PublicKey)((PemEntry)pemEntryIterator.next()).tryCast(PublicKey.class);
                        }
                        catch (Exception e) {
                            ElytronSubsystemMessages.ROOT_LOGGER.debug(e);
                            throw ElytronSubsystemMessages.ROOT_LOGGER.failedToParsePEMPublicKey(kid);
                        }
                        if (namedPublicKey == null) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.failedToParsePEMPublicKey(kid);
                        }
                        namedKeys.put(kid, namedPublicKey);
                    }
                }
                TrivialService<SecurityRealm> service = new TrivialService<SecurityRealm>(new TrivialService.ValueSupplier<SecurityRealm>(){

                    @Override
                    public SecurityRealm get() throws StartException {
                        KeyStore keyStore;
                        JwtValidator.Builder jwtValidatorBuilder = JwtValidator.builder();
                        if (issuer != null) {
                            jwtValidatorBuilder.issuer(issuer);
                        }
                        if (audience != null) {
                            jwtValidatorBuilder.audience(audience);
                        }
                        if (publicKey != null) {
                            jwtValidatorBuilder.publicKey(publicKey.getBytes(StandardCharsets.UTF_8));
                        }
                        if (sslContextRef != null) {
                            jwtValidatorBuilder.useSslContext((SSLContext)sslContextInjector.getOptionalValue());
                        }
                        if (hostNameVerificationPolicy != null) {
                            jwtValidatorBuilder.useSslHostnameVerifier(OAuth2IntrospectionValidatorAttributes.HostnameVerificationPolicy.valueOf(hostNameVerificationPolicy).getVerifier());
                        }
                        if (namedKeys.size() > 0) {
                            jwtValidatorBuilder.publicKeys(namedKeys);
                        }
                        if ((keyStore = (KeyStore)keyStoreInjector.getOptionalValue()) != null) {
                            try {
                                Certificate certificate = keyStore.getCertificate(certificateAlias);
                                if (certificate == null) {
                                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToAccessEntryFromKeyStore(certificateAlias, keyStoreName);
                                }
                                jwtValidatorBuilder.publicKey(certificate.getPublicKey());
                            }
                            catch (KeyStoreException cause) {
                                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(cause);
                            }
                        }
                        return TokenSecurityRealm.builder().principalClaimName(principalClaimNode.asString()).validator((TokenValidator)jwtValidatorBuilder.build()).build();
                    }

                    @Override
                    public void dispose() {
                    }
                });
                ServiceBuilder serviceBuilder = serviceTarget.addService(mainServiceName, service);
                String keyStore = JwtValidatorAttributes.KEY_STORE.resolveModelAttribute(context, jwtValidatorNode).asStringOrNull();
                if (keyStore != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-store", (String)keyStore), KeyStore.class), KeyStore.class, (Injector)keyStoreInjector);
                }
                if (sslContextRef != null) {
                    String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.ssl-context", (String)sslContextRef);
                    serviceBuilder.addDependency(context.getCapabilityServiceName(runtimeCapability, SSLContext.class), SSLContext.class, (Injector)sslContextInjector);
                }
                serviceBuilder.addAliases(new ServiceName[]{aliasServiceName}).install();
            } else if (operation.hasDefined("oauth2-introspection")) {
                ModelNode oAuth2IntrospectionNode = OAuth2IntrospectionValidatorAttributes.OAUTH2_INTROSPECTION_VALIDATOR.resolveModelAttribute(context, operation);
                final String clientId = OAuth2IntrospectionValidatorAttributes.CLIENT_ID.resolveModelAttribute(context, oAuth2IntrospectionNode).asString();
                final String clientSecret = OAuth2IntrospectionValidatorAttributes.CLIENT_SECRET.resolveModelAttribute(context, oAuth2IntrospectionNode).asString();
                final String introspectionUrl = OAuth2IntrospectionValidatorAttributes.INTROSPECTION_URL.resolveModelAttribute(context, oAuth2IntrospectionNode).asString();
                String sslContextRef = SSL_CONTEXT.resolveModelAttribute(context, oAuth2IntrospectionNode).asStringOrNull();
                final String hostNameVerificationPolicy = HOSTNAME_VERIFICATION_POLICY.resolveModelAttribute(context, oAuth2IntrospectionNode).asStringOrNull();
                final InjectedValue sslContextInjector = new InjectedValue();
                TrivialService<SecurityRealm> service = new TrivialService<SecurityRealm>(new TrivialService.ValueSupplier<SecurityRealm>(){

                    @Override
                    public SecurityRealm get() throws StartException {
                        try {
                            HostnameVerifier verifier = null;
                            if (hostNameVerificationPolicy != null) {
                                verifier = OAuth2IntrospectionValidatorAttributes.HostnameVerificationPolicy.valueOf(hostNameVerificationPolicy).getVerifier();
                            }
                            OAuth2IntrospectValidator.Builder builder = OAuth2IntrospectValidator.builder().clientId(clientId).clientSecret(clientSecret).tokenIntrospectionUrl(new URL(introspectionUrl)).useSslContext((SSLContext)sslContextInjector.getOptionalValue()).useSslHostnameVerifier(verifier);
                            return TokenSecurityRealm.builder().principalClaimName(principalClaimNode.asString()).validator((TokenValidator)builder.build()).build();
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException("Failed to parse token introspection URL.", e);
                        }
                    }

                    @Override
                    public void dispose() {
                    }
                });
                ServiceBuilder serviceBuilder = serviceTarget.addService(mainServiceName, service).addAliases(new ServiceName[]{aliasServiceName});
                if (sslContextRef != null) {
                    String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.ssl-context", (String)sslContextRef);
                    serviceBuilder.addDependency(context.getCapabilityServiceName(runtimeCapability, SSLContext.class), SSLContext.class, (Injector)sslContextInjector);
                }
                serviceBuilder.install();
            }
        }

        private String[] asStringArrayIfDefined(OperationContext context, StringListAttributeDefinition attributeDefinition, ModelNode model) throws OperationFailedException {
            ModelNode resolved = attributeDefinition.resolveModelAttribute(context, model);
            if (resolved.isDefined()) {
                List values = resolved.asList();
                String[] response = new String[values.size()];
                for (int i = 0; i < response.length; ++i) {
                    response[i] = ((ModelNode)values.get(i)).asString();
                }
                return response;
            }
            return null;
        }
    }

    static class OAuth2IntrospectionValidatorAttributes {
        static final SimpleAttributeDefinition CLIENT_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-id", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition CLIENT_SECRET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-secret", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition INTROSPECTION_URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("introspection-url", ModelType.STRING, false).setAllowExpression(true)).setValidator((ParameterValidator)new URLValidator())).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CLIENT_ID, CLIENT_SECRET, INTROSPECTION_URL, SSL_CONTEXT, HOSTNAME_VERIFICATION_POLICY};
        static final ObjectTypeAttributeDefinition OAUTH2_INTROSPECTION_VALIDATOR = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("oauth2-introspection", new AttributeDefinition[]{CLIENT_ID, CLIENT_SECRET, INTROSPECTION_URL, SSL_CONTEXT, HOSTNAME_VERIFICATION_POLICY}).setRequired(false)).setRestartAllServices()).build();

        OAuth2IntrospectionValidatorAttributes() {
        }

        static enum HostnameVerificationPolicy {
            ANY((s, sslSession) -> true),
            DEFAULT(HttpsURLConnection.getDefaultHostnameVerifier());

            private final HostnameVerifier verifier;

            private HostnameVerificationPolicy(HostnameVerifier verifier) {
                this.verifier = verifier;
            }

            HostnameVerifier getVerifier() {
                return this.verifier;
            }
        }
    }

    static class JwtValidatorAttributes {
        static final StringListAttributeDefinition ISSUER = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("issuer").setAllowExpression(true)).setRequired(false)).setMinSize(1)).build();
        static final StringListAttributeDefinition AUDIENCE = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("audience").setAllowExpression(true)).setRequired(false)).setMinSize(1)).build();
        static final SimpleAttributeDefinition PUBLIC_KEY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("public-key", ModelType.STRING, true).setAlternatives(new String[]{"key-store", "certificate"})).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition KEY_STORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-store", ModelType.STRING, true).setAlternatives(new String[]{"public-key"})).setRequires(new String[]{"certificate"})).setMinSize(1)).setCapabilityReference("org.wildfly.security.key-store", "org.wildfly.security.security-realm")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAllowExpression(false)).build();
        static final SimpleAttributeDefinition CERTIFICATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("certificate", ModelType.STRING, true).setAlternatives(new String[]{"public-key"})).setRequires(new String[]{KEY_STORE.getName()})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setMinSize(1)).build();
        static final PropertiesAttributeDefinition KEY_MAP = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("key-map", true).setAllowExpression(true)).setMinSize(1)).setAttributeParser((AttributeParser)new AttributeParsers.PropertiesParser(null, "key", false){

            public void parseSingleElement(MapAttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
                String[] array = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{"kid", "public-key"});
                ModelNode paramVal = operation.get(attribute.getName()).get(array[0]);
                paramVal.set(array[1]);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            }
        })).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.PropertiesAttributeMarshaller(null, null, false){

            public void marshallSingleElement(AttributeDefinition attribute, ModelNode property, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
                writer.writeEmptyElement("key");
                writer.writeAttribute("kid", property.asProperty().getName());
                writer.writeAttribute("public-key", property.asProperty().getValue().asString());
            }
        })).setRestartAllServices()).build();
        static final ObjectTypeAttributeDefinition JWT_VALIDATOR = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("jwt", new AttributeDefinition[]{ISSUER, AUDIENCE, PUBLIC_KEY, KEY_STORE, CERTIFICATE, SSL_CONTEXT, HOSTNAME_VERIFICATION_POLICY, KEY_MAP}).setRequired(false)).setRestartAllServices()).build();

        JwtValidatorAttributes() {
        }
    }
}

