/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.join.impl;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.hibernate.search.util.common.AssertionFailure;

public class ChildDocIds {
    private final BitSet parentDocs;
    private final DocIdSetIterator childDocs;
    private int currentParentDocId = -1;
    private int lastReturnedChildDocId = -1;

    public ChildDocIds(BitSet parentDocs, DocIdSetIterator childDocs) {
        this.parentDocs = parentDocs;
        this.childDocs = childDocs;
    }

    public boolean advanceExactParent(int parentDocId) throws IOException {
        if (parentDocId <= this.currentParentDocId) {
            throw new AssertionFailure("This iterator can only move forward (no advancing to the same doc twice, no going backward)");
        }
        this.currentParentDocId = parentDocId;
        this.lastReturnedChildDocId = -1;
        int prevParentDocId = parentDocId == 0 ? -1 : this.parentDocs.prevSetBit(parentDocId - 1);
        int firstChildDocId = this.nextChild(prevParentDocId + 1);
        if (firstChildDocId < this.currentParentDocId) {
            this.lastReturnedChildDocId = -1;
            return true;
        }
        return false;
    }

    public int nextChild() throws IOException {
        if (this.lastReturnedChildDocId == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return this.nextChild(this.lastReturnedChildDocId + 1);
    }

    public int nextChild(int target) throws IOException {
        if (this.currentParentDocId <= this.lastReturnedChildDocId || this.currentParentDocId <= target) {
            this.lastReturnedChildDocId = Integer.MAX_VALUE;
            return this.lastReturnedChildDocId;
        }
        int nextChild = 0 <= this.childDocs.docID() && target <= this.childDocs.docID() ? this.childDocs.docID() : this.childDocs.advance(target);
        if (this.currentParentDocId <= nextChild) {
            nextChild = Integer.MAX_VALUE;
        }
        this.lastReturnedChildDocId = nextChild;
        return nextChild;
    }
}

