/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2021, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.wildfly.extension.microprofile.health;

import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentResourceXMLParser;

import static org.jboss.as.controller.PersistentResourceXMLDescription.builder;
import static org.wildfly.extension.microprofile.health.MicroProfileHealthSubsystemDefinition.EMPTY_LIVENESS_CHECKS_STATUS;
import static org.wildfly.extension.microprofile.health.MicroProfileHealthSubsystemDefinition.EMPTY_READINESS_CHECKS_STATUS;
import static org.wildfly.extension.microprofile.health.MicroProfileHealthSubsystemDefinition.EMPTY_STARTUP_CHECKS_STATUS;
import static org.wildfly.extension.microprofile.health.MicroProfileHealthSubsystemDefinition.SECURITY_ENABLED;

/**
 * @author <a href="http://xstefank.io/">Martin Stefanko</a> (c) 2021 Red Hat inc.
 */
public class MicroProfileHealthParser_3_0 extends PersistentResourceXMLParser {
    /**
     * The name space used for the {@code subsystem} element
     */
    public static final String NAMESPACE = "urn:wildfly:microprofile-health-smallrye:3.0";

    private static final PersistentResourceXMLDescription xmlDescription;

    static {
        xmlDescription = builder(MicroProfileHealthExtension.SUBSYSTEM_PATH, NAMESPACE)
                .addAttributes(SECURITY_ENABLED,
                        EMPTY_LIVENESS_CHECKS_STATUS,
                        EMPTY_READINESS_CHECKS_STATUS,
                        EMPTY_STARTUP_CHECKS_STATUS)
                .build();
    }

    @Override
    public PersistentResourceXMLDescription getParserDescription() {
        return xmlDescription;
    }
}
