/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.jboss.as.controller.persistence.ConfigurationExtension;

public class ConfigurationExtensionFactory {
    private static final ConfigurationExtension extension;

    public static boolean isConfigurationExtensionSupported() {
        return extension != null;
    }

    public static String getCommandLineInstructions() {
        if (extension != null) {
            return extension.getCommandLineInstructions();
        }
        return "";
    }

    public static String[] getCommandLineUsageArguments() {
        if (extension != null) {
            return extension.getCommandLineUsageArguments();
        }
        return new String[0];
    }

    public static boolean commandLineContainsArgument(String arg) {
        if (extension != null) {
            return extension.commandLineContainsArgument(arg);
        }
        return false;
    }

    public static ConfigurationExtension createConfigurationExtension(Path ... files) {
        if (ConfigurationExtensionFactory.isConfigurationExtensionSupported() && files != null && files.length > 0) {
            return extension.load(files);
        }
        return null;
    }

    static {
        ServiceLoader<ConfigurationExtension> loader = ServiceLoader.load(ConfigurationExtension.class, ConfigurationExtensionFactory.class.getClassLoader());
        Iterator<ConfigurationExtension> iter = loader.iterator();
        extension = iter.hasNext() ? iter.next() : null;
    }
}

