/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagReader;
import org.wildfly.clustering.marshalling.protostream.AbstractProtoStreamOperation;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamOperation;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.Reference;

public class DefaultProtoStreamReader
extends AbstractProtoStreamOperation
implements ProtoStreamReader,
ProtobufTagMarshaller.ReadContext {
    private final TagReader reader;
    private final ProtoStreamReaderContext context;

    public DefaultProtoStreamReader(ProtobufTagMarshaller.ReadContext context) {
        this(context, new DefaultProtoStreamReaderContext());
    }

    private DefaultProtoStreamReader(ProtobufTagMarshaller.ReadContext context, ProtoStreamReaderContext readerContext) {
        super((ProtobufTagMarshaller.OperationContext)context);
        this.reader = context.getReader();
        this.context = readerContext;
    }

    @Override
    public Object readAny() throws IOException {
        Object result = this.readObject(Any.class).get();
        if (result instanceof Reference) {
            Reference reference = (Reference)result;
            result = this.context.resolve(reference);
        } else {
            this.context.record(result);
        }
        return result;
    }

    @Override
    public ProtoStreamOperation.Context getContext() {
        return this.context;
    }

    public TagReader getReader() {
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T readObject(Class<T> targetClass) throws IOException {
        int limit = this.reader.readUInt32();
        int oldLimit = this.reader.pushLimit(limit);
        try {
            ProtoStreamMarshaller marshaller = this.findMarshaller(targetClass);
            Object result = marshaller.readFrom(this);
            this.reader.checkLastTagWas(0);
            Object object = result;
            return (T)object;
        }
        finally {
            this.reader.popLimit(oldLimit);
        }
    }

    public int pushLimit(int limit) throws IOException {
        return this.reader.pushLimit(limit);
    }

    public void popLimit(int oldLimit) {
        this.reader.popLimit(oldLimit);
    }

    public boolean isAtEnd() throws IOException {
        return this.reader.isAtEnd();
    }

    public int readTag() throws IOException {
        return this.reader.readTag();
    }

    public void checkLastTagWas(int tag) throws IOException {
        this.reader.checkLastTagWas(tag);
    }

    public boolean skipField(int tag) throws IOException {
        return this.reader.skipField(tag);
    }

    public boolean readBool() throws IOException {
        return this.reader.readBool();
    }

    public int readEnum() throws IOException {
        return this.reader.readEnum();
    }

    @Override
    @Deprecated
    public int readInt32() throws IOException {
        return this.reader.readInt32();
    }

    @Override
    @Deprecated
    public int readFixed32() throws IOException {
        return this.reader.readFixed32();
    }

    public int readUInt32() throws IOException {
        return this.reader.readUInt32();
    }

    public int readSInt32() throws IOException {
        return this.reader.readSInt32();
    }

    public int readSFixed32() throws IOException {
        return this.reader.readSFixed32();
    }

    @Override
    @Deprecated
    public long readInt64() throws IOException {
        return this.reader.readInt64();
    }

    @Override
    @Deprecated
    public long readFixed64() throws IOException {
        return this.reader.readFixed64();
    }

    public long readUInt64() throws IOException {
        return this.reader.readUInt64();
    }

    public long readSInt64() throws IOException {
        return this.reader.readSInt64();
    }

    public long readSFixed64() throws IOException {
        return this.reader.readSFixed64();
    }

    public float readFloat() throws IOException {
        return this.reader.readFloat();
    }

    public double readDouble() throws IOException {
        return this.reader.readDouble();
    }

    public byte[] readByteArray() throws IOException {
        return this.reader.readByteArray();
    }

    public ByteBuffer readByteBuffer() throws IOException {
        return this.reader.readByteBuffer();
    }

    public String readString() throws IOException {
        return this.reader.readString();
    }

    public byte[] fullBufferArray() throws IOException {
        return this.reader.fullBufferArray();
    }

    public InputStream fullBufferInputStream() throws IOException {
        return this.reader.fullBufferInputStream();
    }

    public boolean isInputStream() {
        return this.reader.isInputStream();
    }

    private static class DefaultProtoStreamReaderContext
    implements ProtoStreamReaderContext {
        private final Map<Object, Boolean> objects = new IdentityHashMap<Object, Boolean>(128);
        private final List<Object> references = new ArrayList<Object>(128);

        private DefaultProtoStreamReaderContext() {
        }

        @Override
        public void record(Object object) {
            if (object != null && this.objects.putIfAbsent(object, Boolean.TRUE) == null) {
                this.references.add(object);
            }
        }

        @Override
        public Object resolve(Reference reference) {
            return this.references.get(reference.getAsInt());
        }
    }

    static interface ProtoStreamReaderContext
    extends ProtoStreamOperation.Context {
        public Object resolve(Reference var1);
    }
}

