/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.spi;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.reporting.spi.BackendMappingHints;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentValueConvertContextImpl;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.engine.mapper.mapping.spi.MappingPreStopContext;
import org.hibernate.search.engine.mapper.mapping.spi.MappingStartContext;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.search.projection.definition.spi.ProjectionRegistry;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeToDocumentIdentifierContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.IdentifierBridgeToDocumentIdentifierContextImpl;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.ValueBridgeToIndexedValueContextImpl;
import org.hibernate.search.mapper.pojo.common.spi.PojoEntityReference;
import org.hibernate.search.mapper.pojo.common.spi.PojoEntityReferenceFactoryDelegate;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeMappingContext;
import org.hibernate.search.mapper.pojo.session.spi.PojoSearchSessionMappingContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventProcessingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventSendingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.impl.Closer;

public abstract class AbstractPojoMappingImplementor<M>
implements MappingImplementor<M>,
PojoScopeMappingContext,
PojoSearchSessionMappingContext {
    private final PojoMappingDelegate delegate;
    private boolean stopped = false;
    private final PojoEntityReferenceFactoryDelegate entityReferenceFactoryDelegate;
    private final EntityReferenceFactory entityReferenceFactory;
    private final ToDocumentValueConvertContext toDocumentValueConvertContext;
    private final IdentifierBridgeToDocumentIdentifierContext toDocumentIdentifierContext;
    private final ValueBridgeToIndexedValueContext toIndexedValueContext;

    public AbstractPojoMappingImplementor(PojoMappingDelegate delegate) {
        this(delegate, PojoEntityReference::new);
    }

    @Deprecated
    public AbstractPojoMappingImplementor(PojoMappingDelegate delegate, PojoEntityReferenceFactoryDelegate entityReferenceFactoryDelegate) {
        this.delegate = delegate;
        this.entityReferenceFactoryDelegate = entityReferenceFactoryDelegate;
        this.entityReferenceFactory = delegate.createEntityReferenceFactory(entityReferenceFactoryDelegate);
        this.toDocumentValueConvertContext = new ToDocumentValueConvertContextImpl((BackendMappingContext)this);
        this.toDocumentIdentifierContext = new IdentifierBridgeToDocumentIdentifierContextImpl(this);
        this.toIndexedValueContext = new ValueBridgeToIndexedValueContextImpl(this);
    }

    public CompletableFuture<?> start(MappingStartContext context) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<?> preStop(MappingPreStopContext context) {
        return CompletableFuture.completedFuture(null);
    }

    public void stop() {
        if (!this.stopped) {
            this.stopped = true;
            try (Closer closer = new Closer();){
                closer.push(PojoMappingDelegate::close, (Object)this.delegate);
                closer.push(AbstractPojoMappingImplementor::doStop, (Object)this);
            }
        }
    }

    public BackendMappingHints hints() {
        return BackendMappingHints.NONE;
    }

    @Override
    public ThreadPoolProvider threadPoolProvider() {
        return this.delegate().threadPoolProvider();
    }

    @Override
    public FailureHandler failureHandler() {
        return this.delegate().failureHandler();
    }

    @Override
    public final PojoEntityReferenceFactoryDelegate entityReferenceFactoryDelegate() {
        return this.entityReferenceFactoryDelegate;
    }

    public final EntityReferenceFactory entityReferenceFactory() {
        return this.entityReferenceFactory;
    }

    public final ToDocumentValueConvertContext toDocumentValueConvertContext() {
        return this.toDocumentValueConvertContext;
    }

    public ProjectionRegistry projectionRegistry() {
        return this.delegate.projectionRegistry();
    }

    @Override
    public final IdentifierBridgeToDocumentIdentifierContext identifierBridgeToDocumentIdentifierContext() {
        return this.toDocumentIdentifierContext;
    }

    @Override
    public ValueBridgeToIndexedValueContext valueBridgeToIndexedValueContext() {
        return this.toIndexedValueContext;
    }

    @Override
    public PojoIndexingPlan createIndexingPlan(PojoWorkSessionContext context, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.delegate.createIndexingPlan(context, commitStrategy, refreshStrategy);
    }

    @Override
    public PojoIndexingPlan createIndexingPlan(PojoWorkSessionContext context, PojoIndexingQueueEventSendingPlan sendingPlan) {
        return this.delegate.createIndexingPlan(context, sendingPlan);
    }

    @Override
    public PojoIndexer createIndexer(PojoWorkSessionContext context) {
        return this.delegate.createIndexer(context);
    }

    @Override
    public PojoIndexingQueueEventProcessingPlan createIndexingQueueEventProcessingPlan(PojoWorkSessionContext context, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy, PojoIndexingQueueEventSendingPlan sendingPlan) {
        return this.delegate.createEventProcessingPlan(context, commitStrategy, refreshStrategy, sendingPlan);
    }

    protected final PojoMappingDelegate delegate() {
        return this.delegate;
    }

    protected void doStop() {
    }
}

