/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.affinity.impl;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.logging.Logger;
import org.wildfly.clustering.context.DefaultExecutorService;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.infinispan.affinity.impl.ConsistentHashKeyRegistry;
import org.wildfly.clustering.infinispan.affinity.impl.KeyRegistry;
import org.wildfly.clustering.infinispan.distribution.ConsistentHashKeyDistribution;
import org.wildfly.clustering.infinispan.distribution.KeyDistribution;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener(observation=Listener.Observation.POST)
public class DefaultKeyAffinityService<K>
implements KeyAffinityService<K>,
Supplier<BlockingQueue<K>> {
    private static final Logger LOGGER = Logger.getLogger(DefaultKeyAffinityService.class);
    private final Cache<? extends K, ?> cache;
    private final KeyGenerator<? extends K> generator;
    private final AtomicReference<KeyAffinityState<K>> currentState = new AtomicReference();
    private final KeyPartitioner partitioner;
    private final Predicate<Address> filter;
    private volatile int queueSize = 100;
    private volatile Duration timeout = Duration.ofMillis(100L);
    private volatile ExecutorService executor;

    public DefaultKeyAffinityService(Cache<? extends K, ?> cache, KeyGenerator<? extends K> generator, Predicate<Address> filter) {
        this(cache, (KeyPartitioner)cache.getAdvancedCache().getComponentRegistry().getLocalComponent(KeyPartitioner.class), generator, filter);
    }

    DefaultKeyAffinityService(Cache<? extends K, ?> cache, KeyPartitioner partitioner, KeyGenerator<? extends K> generator, Predicate<Address> filter) {
        this.cache = cache;
        this.partitioner = partitioner;
        this.generator = generator;
        this.filter = filter;
    }

    public void setQueueSize(int size) {
        this.queueSize = size;
    }

    public void setPollTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    @Override
    public BlockingQueue<K> get() {
        return new ArrayBlockingQueue(this.queueSize);
    }

    public boolean isStarted() {
        ExecutorService executor = this.executor;
        return executor != null && !executor.isShutdown();
    }

    public void start() {
        this.executor = Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory(this.getClass()));
        this.accept(this.cache.getAdvancedCache().getDistributionManager().getCacheTopology().getWriteConsistentHash());
        this.cache.addListener((Object)this);
    }

    public void stop() {
        this.cache.removeListener((Object)this);
        WildFlySecurityManager.doUnchecked((Object)this.executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
    }

    public K getCollocatedKey(K otherKey) {
        KeyAffinityState<K> currentState = this.currentState.get();
        if (currentState == null) {
            throw new IllegalStateException();
        }
        return this.getCollocatedKey(currentState, otherKey);
    }

    private K getCollocatedKey(KeyAffinityState<K> state, K otherKey) {
        K key = this.poll(state.getRegistry(), state.getDistribution().getPrimaryOwner(otherKey));
        if (key != null) {
            return key;
        }
        KeyAffinityState<K> currentState = this.currentState.get();
        if (state != currentState) {
            return this.getCollocatedKey(currentState, otherKey);
        }
        LOGGER.debugf("Could not obtain pre-generated key with same affinity as %s -- generating random key", otherKey);
        return (K)this.generator.getKey();
    }

    public K getKeyForAddress(Address address) {
        if (!this.filter.test(address)) {
            throw new IllegalArgumentException(address.toString());
        }
        KeyAffinityState<K> currentState = this.currentState.get();
        if (currentState == null) {
            throw new IllegalStateException();
        }
        return this.getKeyForAddress(currentState, address);
    }

    private K getKeyForAddress(KeyAffinityState<K> state, Address address) {
        K key = this.poll(state.getRegistry(), address);
        if (key != null) {
            return key;
        }
        KeyAffinityState<K> currentState = this.currentState.get();
        if (state != currentState) {
            return this.getKeyForAddress(currentState, address);
        }
        LOGGER.debugf("Could not obtain pre-generated key with affinity for %s -- generating random key", (Object)address);
        return (K)this.generator.getKey();
    }

    private K poll(KeyRegistry<K> registry, Address address) {
        BlockingQueue<K> keys = registry.getKeys(address);
        if (keys != null) {
            Duration timeout = this.timeout;
            long nanos = timeout.getSeconds() == 0L ? (long)timeout.getNano() : timeout.toNanos();
            try {
                return keys.poll(nanos, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    @TopologyChanged
    public CompletionStage<Void> topologyChanged(TopologyChangedEvent<?, ?> event) {
        if (!this.getSegments(event.getWriteConsistentHashAtStart()).equals(this.getSegments(event.getWriteConsistentHashAtEnd()))) {
            LOGGER.debugf("Restarting key generation based on new consistent hash for topology %d", event.getNewTopologyId());
            this.accept(event.getWriteConsistentHashAtEnd());
        }
        return CompletableFuture.completedStage(null);
    }

    private Map<Address, Set<Integer>> getSegments(ConsistentHash hash) {
        TreeMap<Address, Set<Integer>> segments = new TreeMap<Address, Set<Integer>>();
        for (Address address : hash.getMembers()) {
            if (!this.filter.test(address)) continue;
            segments.put(address, hash.getPrimarySegmentsForOwner(address));
        }
        return segments;
    }

    private void accept(ConsistentHash hash) {
        block5: {
            final ConsistentHashKeyDistribution distribution = new ConsistentHashKeyDistribution(this.partitioner, hash);
            final ConsistentHashKeyRegistry registry = new ConsistentHashKeyRegistry(hash, this.filter, this);
            Set<Address> addresses = registry.getAddresses();
            final ArrayList futures = !addresses.isEmpty() ? new ArrayList(addresses.size()) : Collections.emptyList();
            try {
                for (Address address : addresses) {
                    BlockingQueue blockingQueue = registry.getKeys(address);
                    futures.add(this.executor.submit(new GenerateKeysTask<K>(this.generator, distribution, address, blockingQueue)));
                }
                KeyAffinityState previousState = this.currentState.getAndSet(new KeyAffinityState<K>(){

                    @Override
                    public KeyDistribution getDistribution() {
                        return distribution;
                    }

                    @Override
                    public KeyRegistry<K> getRegistry() {
                        return registry;
                    }

                    @Override
                    public Iterable<Future<?>> getFutures() {
                        return futures;
                    }
                });
                if (previousState == null) break block5;
                for (Future<?> future : previousState.getFutures()) {
                    future.cancel(true);
                }
            }
            catch (RejectedExecutionException e) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
    }

    private static class GenerateKeysTask<K>
    implements Runnable {
        private final KeyGenerator<? extends K> generator;
        private final KeyDistribution distribution;
        private final Address address;
        private final BlockingQueue<K> keys;

        GenerateKeysTask(KeyGenerator<? extends K> generator, KeyDistribution distribution, Address address, BlockingQueue<K> keys) {
            this.generator = generator;
            this.distribution = distribution;
            this.address = address;
            this.keys = keys;
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                Object key = this.generator.getKey();
                if (!this.distribution.getPrimaryOwner(key).equals(this.address)) continue;
                try {
                    this.keys.put(key);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static interface KeyAffinityState<K> {
        public KeyDistribution getDistribution();

        public KeyRegistry<K> getRegistry();

        public Iterable<Future<?>> getFutures();
    }
}

