/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.envers.internal.entities.EntityConfiguration;

public class AuditEntityConfigurationRegistry {
    private final Map<String, EntityConfiguration> auditedEntityConfigurations = new HashMap<String, EntityConfiguration>();
    private final Map<String, EntityConfiguration> notAuditedEntityConfigurations = new HashMap<String, EntityConfiguration>();

    public Map<String, EntityConfiguration> getAuditedEntityConfigurations() {
        return Collections.unmodifiableMap(this.auditedEntityConfigurations);
    }

    public Map<String, EntityConfiguration> getNotAuditedEntityConfigurations() {
        return Collections.unmodifiableMap(this.notAuditedEntityConfigurations);
    }

    public boolean hasAuditedEntityConfiguration(String entityName) {
        return this.auditedEntityConfigurations.containsKey(entityName);
    }

    public boolean hasNotAuditedEntityConfiguration(String entityName) {
        return this.notAuditedEntityConfigurations.containsKey(entityName);
    }

    public EntityConfiguration getAuditedEntityConfiguration(String entityName) {
        return this.auditedEntityConfigurations.get(entityName);
    }

    public EntityConfiguration getNotAuditedEntityConfiguration(String entityName) {
        return this.notAuditedEntityConfigurations.get(entityName);
    }

    public void addAuditedEntityConfiguration(String entityName, EntityConfiguration entityConfiguration) {
        this.auditedEntityConfigurations.put(entityName, entityConfiguration);
    }

    public void addNotAuditedEntityConfiguration(String entityName, EntityConfiguration entityConfiguration) {
        this.notAuditedEntityConfigurations.put(entityName, entityConfiguration);
    }
}

