/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.jboss.logging.Logger;

public class SizeAwareMetric {
    private static final Logger logger = Logger.getLogger(SizeAwareMetric.class);
    private static final int PENDING_FREE = 0;
    private static final int FREE = 1;
    private static final int PENDING_OVER_SIZE = 2;
    private static final int OVER_SIZE = 3;
    private static final int PENDING_OVER_ELEMENTS = 4;
    private static final int OVER_ELEMENTS = 5;
    private static final int NOT_USED = -1;
    private static final AtomicLongFieldUpdater<SizeAwareMetric> elementsUpdater = AtomicLongFieldUpdater.newUpdater(SizeAwareMetric.class, "elements");
    private volatile long elements;
    private static final AtomicLongFieldUpdater<SizeAwareMetric> sizeUpdater = AtomicLongFieldUpdater.newUpdater(SizeAwareMetric.class, "size");
    private volatile long size;
    private static final AtomicIntegerFieldUpdater<SizeAwareMetric> flagUpdater = AtomicIntegerFieldUpdater.newUpdater(SizeAwareMetric.class, "flag");
    private volatile int flag = -1;
    private long maxElements;
    private long lowerMarkElements;
    private long maxSize;
    private long lowerMarkSize;
    private boolean sizeEnabled = false;
    private boolean elementsEnabled = false;
    private AddCallback onSizeCallback;
    private Runnable overCallback;
    private Runnable underCallback;

    public SizeAwareMetric() {
        this.sizeEnabled = false;
        this.elementsEnabled = false;
    }

    public SizeAwareMetric(long maxSize, long lowerMarkSize, long maxElements, long lowerMarkElements) {
        if (lowerMarkSize > maxSize) {
            throw new IllegalArgumentException("lowerMark must be <= maxSize");
        }
        if (lowerMarkElements > maxElements) {
            throw new IllegalArgumentException("lowerMarkElements must be <= maxElements");
        }
        this.maxElements = maxElements;
        this.lowerMarkElements = lowerMarkElements;
        this.maxSize = maxSize;
        this.lowerMarkSize = lowerMarkSize;
        this.sizeEnabled = maxSize >= 0L;
        this.elementsEnabled = maxElements >= 0L;
    }

    public boolean isOver() {
        return this.flag > 1;
    }

    public boolean isOverSize() {
        return this.flag == 3;
    }

    public boolean isOverElements() {
        return this.flag == 5;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isElementsEnabled() {
        return this.elementsEnabled;
    }

    public SizeAwareMetric setElementsEnabled(boolean elementsEnabled) {
        this.elementsEnabled = elementsEnabled;
        return this;
    }

    public long getElements() {
        return this.elements;
    }

    public boolean isSizeEnabled() {
        return this.sizeEnabled;
    }

    public SizeAwareMetric setSizeEnabled(boolean sizeEnabled) {
        this.sizeEnabled = sizeEnabled;
        return this;
    }

    public SizeAwareMetric setOnSizeCallback(AddCallback onSize) {
        this.onSizeCallback = onSize;
        return this;
    }

    public SizeAwareMetric setOverCallback(Runnable over) {
        this.overCallback = over;
        return this;
    }

    public SizeAwareMetric setUnderCallback(Runnable under) {
        this.underCallback = under;
        return this;
    }

    protected void over() {
        if (this.overCallback != null) {
            try {
                this.overCallback.run();
            }
            catch (Throwable e) {
                logger.warn((Object)e.getMessage(), e);
            }
        }
    }

    protected void under() {
        if (this.underCallback != null) {
            try {
                this.underCallback.run();
            }
            catch (Throwable e) {
                logger.warn((Object)e.getMessage(), e);
            }
        }
    }

    private boolean changeFlag(int expected, int newValue) {
        return flagUpdater.compareAndSet(this, expected, newValue);
    }

    public final long addSize(int delta) {
        return this.addSize(delta, false);
    }

    public final long addSize(int delta, boolean sizeOnly) {
        if (delta == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"SizeAwareMetric ignored with size 0", new Exception("trace"));
            }
            return sizeUpdater.get(this);
        }
        this.changeFlag(-1, 1);
        if (this.onSizeCallback != null) {
            try {
                this.onSizeCallback.add(delta, sizeOnly);
            }
            catch (Throwable e) {
                logger.warn((Object)e.getMessage(), e);
            }
        }
        long currentSize = sizeUpdater.addAndGet(this, delta);
        long currentElements = sizeOnly ? elementsUpdater.get(this) : (delta > 0 ? elementsUpdater.incrementAndGet(this) : elementsUpdater.decrementAndGet(this));
        if (delta > 0) {
            this.checkOver(currentElements, currentSize);
        } else {
            this.checkUnder(currentElements, currentSize);
        }
        return currentSize;
    }

    public void setMax(long maxSize, long lowerMarkSize, long maxElements, long lowerMarkElements) {
        this.maxSize = maxSize;
        this.lowerMarkSize = lowerMarkSize;
        this.maxElements = maxElements;
        this.lowerMarkElements = lowerMarkElements;
        long currentSize = sizeUpdater.get(this);
        long currentElements = elementsUpdater.get(this);
        this.checkOver(currentElements, currentSize);
        this.checkUnder(currentElements, currentSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUnder(long currentElements, long currentSize) {
        if (this.sizeEnabled && currentSize <= this.lowerMarkSize && this.changeFlag(3, 0)) {
            if (!this.elementsEnabled || currentElements < this.maxElements || !this.changeFlag(0, 5)) {
                try {
                    this.under();
                }
                finally {
                    this.changeFlag(0, 1);
                }
            }
            return;
        }
        if (this.elementsEnabled && currentElements <= this.lowerMarkElements && this.changeFlag(5, 0)) {
            if (!this.sizeEnabled || currentSize < this.maxSize || !this.changeFlag(0, 3)) {
                try {
                    this.under();
                }
                finally {
                    this.changeFlag(0, 1);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOver(long currentElements, long currentSize) {
        if (this.sizeEnabled && currentSize >= this.maxSize && this.changeFlag(1, 2)) {
            try {
                this.over();
            }
            finally {
                this.changeFlag(2, 3);
            }
        }
        if (this.elementsEnabled && currentElements >= 0L && currentElements >= this.maxElements && this.changeFlag(1, 4)) {
            try {
                this.over();
            }
            finally {
                this.changeFlag(4, 5);
            }
        }
    }

    public String toString() {
        return "SizeAwareMetric{elements=" + this.elements + ", size=" + this.size + "}";
    }

    public static interface AddCallback {
        public void add(int var1, boolean var2);
    }
}

