/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.document.model.spi;

import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.model.spi.AbstractIndexModel;
import org.hibernate.search.engine.backend.document.model.spi.IndexCompositeNode;
import org.hibernate.search.engine.backend.document.model.spi.IndexField;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.common.tree.spi.TreeNodeInclusion;
import org.hibernate.search.util.common.pattern.spi.SimpleGlobPattern;

public abstract class AbstractIndexFieldTemplate<M extends AbstractIndexModel<?, ?, F>, F extends IndexField<?, C>, C extends IndexCompositeNode<?, ?, ?>, FT> {
    private final FT type;
    private final TreeNodeInclusion inclusion;
    private final SimpleGlobPattern absolutePathGlob;
    private final boolean multiValued;

    public AbstractIndexFieldTemplate(C declaringParent, SimpleGlobPattern absolutePathGlob, FT type, TreeNodeInclusion inclusion, boolean multiValued) {
        this.absolutePathGlob = absolutePathGlob;
        this.type = type;
        this.inclusion = declaringParent.inclusion().compose(inclusion);
        this.multiValued = multiValued;
    }

    public final FT type() {
        return this.type;
    }

    public final TreeNodeInclusion inclusion() {
        return this.inclusion;
    }

    F createNodeIfMatching(M model, C root, String absolutePath) {
        if (!this.absolutePathGlob.matches(absolutePath)) {
            return null;
        }
        FieldPaths.RelativizedPath relativizedPath = FieldPaths.relativize(absolutePath);
        IndexCompositeNode parent = relativizedPath.parentPath.map(path -> {
            Object field = model.fieldOrNull((String)path, IndexFieldFilter.ALL);
            return field.toComposite();
        }).orElse((IndexCompositeNode)root);
        return this.createNode(parent, relativizedPath.relativePath, this.type, this.inclusion, this.multiValued);
    }

    protected abstract F createNode(C var1, String var2, FT var3, TreeNodeInclusion var4, boolean var5);
}

