/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.jar.impl;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class CodeSource
implements Closeable {
    private static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private static final String JAR_URI_PATH_SEPARATOR = "!/";
    private final URL codeSourceLocation;
    private FileSystem nonDefaultFileSystem;
    private Path classesPathInFileSystem;

    CodeSource(URL codeSourceLocation) {
        this.codeSourceLocation = codeSourceLocation;
    }

    public InputStream readOrNull(String resourcePathString) throws IOException {
        Exception exception = null;
        try {
            Path rootResourcePath;
            Path relativeResourcePath = this.classesPathOrFail().resolve(resourcePathString);
            if (Files.exists(relativeResourcePath, new LinkOption[0])) {
                return Files.newInputStream(relativeResourcePath, new OpenOption[0]);
            }
            if (this.nonDefaultFileSystem != null && Files.exists(rootResourcePath = this.nonDefaultFileSystem.getRootDirectories().iterator().next().resolve(resourcePathString), new LinkOption[0])) {
                return Files.newInputStream(rootResourcePath, new OpenOption[0]);
            }
            return null;
        }
        catch (IOException | RuntimeException e) {
            exception = Throwables.combine(exception, e);
            try {
                URL resourceUrl = new URL(this.codeSourceLocation, resourcePathString);
                return resourceUrl.openStream();
            }
            catch (FileNotFoundException e2) {
                return null;
            }
            catch (IOException | RuntimeException e3) {
                exception = Throwables.combine(exception, e3);
                throw new IOException("Could not open '" + resourcePathString + "' within '" + this.codeSourceLocation + "': " + exception.getMessage(), exception);
            }
        }
    }

    public Path classesPathOrFail() throws IOException {
        this.initFileSystem();
        return this.classesPathInFileSystem;
    }

    void initFileSystem() throws IOException {
        block7: {
            if (this.classesPathInFileSystem != null) {
                return;
            }
            try {
                if ("jar".equals(this.codeSourceLocation.getProtocol())) {
                    this.tryInitJarFileSystem(this.codeSourceLocation.toURI());
                    break block7;
                }
                if ("file".equals(this.codeSourceLocation.getProtocol())) {
                    Path path = Paths.get(this.codeSourceLocation.toURI());
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        this.nonDefaultFileSystem = null;
                        this.classesPathInFileSystem = path;
                    } else {
                        URI jarUri = new URI("jar:file", null, path.toString(), null);
                        this.tryInitJarFileSystem(jarUri);
                    }
                    break block7;
                }
                throw log.cannotInterpretCodeSourceUrl(this.codeSourceLocation);
            }
            catch (IOException | RuntimeException | URISyntaxException e) {
                throw log.cannotOpenCodeSourceFileSystem(this.codeSourceLocation, e.getMessage(), e);
            }
        }
    }

    private void tryInitJarFileSystem(URI jarUri) throws IOException {
        try {
            this.nonDefaultFileSystem = FileSystems.newFileSystem(jarUri, Collections.emptyMap());
            this.classesPathInFileSystem = this.nonDefaultFileSystem.getRootDirectories().iterator().next();
            String nestedPath = this.extractedJarNestedPath(jarUri);
            if (nestedPath != null) {
                Path nestedPathInFileSystem = this.classesPathInFileSystem.resolve(nestedPath);
                if (Files.isRegularFile(nestedPathInFileSystem, new LinkOption[0])) {
                    throw log.cannotOpenNestedJar(jarUri);
                }
                this.classesPathInFileSystem = nestedPathInFileSystem;
            }
        }
        catch (IOException | RuntimeException e) {
            new SuppressingCloser(e).push(this.nonDefaultFileSystem);
            this.nonDefaultFileSystem = null;
            this.classesPathInFileSystem = null;
            throw e;
        }
    }

    private String extractedJarNestedPath(URI jarUri) throws IOException {
        String spec = jarUri.getSchemeSpecificPart();
        if (spec == null) {
            return null;
        }
        int pathSeparatorIndex = spec.indexOf(JAR_URI_PATH_SEPARATOR);
        if (pathSeparatorIndex < 0) {
            return null;
        }
        int afterPathSeparatorIndex = pathSeparatorIndex + JAR_URI_PATH_SEPARATOR.length();
        int secondPathSeparatorIndex = spec.indexOf(JAR_URI_PATH_SEPARATOR, afterPathSeparatorIndex);
        if (0 <= secondPathSeparatorIndex && secondPathSeparatorIndex + JAR_URI_PATH_SEPARATOR.length() < spec.length()) {
            throw log.cannotOpenNestedJar(jarUri);
        }
        return spec.substring(afterPathSeparatorIndex, secondPathSeparatorIndex);
    }

    @Override
    public void close() throws IOException {
        if (this.nonDefaultFileSystem != null) {
            this.nonDefaultFileSystem.close();
        }
    }
}

