/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.loading.impl.AbstractHibernateOrmLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.EntityLoadingCacheLookupStrategyImplementor;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmSelectionEntityByIdLoader;
import org.hibernate.search.mapper.orm.loading.impl.LoadingSessionContext;
import org.hibernate.search.mapper.orm.loading.impl.LoadingTypeContext;
import org.hibernate.search.mapper.orm.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.loading.impl.PersistenceContextLookupStrategy;
import org.hibernate.search.mapper.orm.loading.impl.PersistenceContextThenSecondLevelCacheLookupStrategy;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionEntityLoader;

public class HibernateOrmEntityIdEntityLoadingStrategy<E, I>
extends AbstractHibernateOrmLoadingStrategy<E, I> {
    private final EntityMappingType rootEntityMappingType;
    private final TypeQueryFactory<E, I> queryFactory;

    public static HibernateOrmEntityLoadingStrategy<?, ?> create(SessionFactoryImplementor sessionFactory, EntityMappingType entityMappingType) {
        EntityMappingType rootEntityMappingType = entityMappingType.getRootEntityDescriptor();
        TypeQueryFactory<?, ?> queryFactory = TypeQueryFactory.create(sessionFactory, rootEntityMappingType, entityMappingType.getIdentifierMapping().getAttributeName());
        return new HibernateOrmEntityIdEntityLoadingStrategy(sessionFactory, rootEntityMappingType, queryFactory);
    }

    HibernateOrmEntityIdEntityLoadingStrategy(SessionFactoryImplementor sessionFactory, EntityMappingType rootEntityMappingType, TypeQueryFactory<E, I> queryFactory) {
        super(sessionFactory, rootEntityMappingType, queryFactory);
        this.rootEntityMappingType = rootEntityMappingType;
        this.queryFactory = queryFactory;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        HibernateOrmEntityIdEntityLoadingStrategy other = (HibernateOrmEntityIdEntityLoadingStrategy)obj;
        return this.rootEntityMappingType.equals(other.rootEntityMappingType);
    }

    @Override
    public int hashCode() {
        return this.rootEntityMappingType.hashCode();
    }

    @Override
    public <E2> PojoSelectionEntityLoader<E2> createLoader(Set<LoadingTypeContext<? extends E2>> targetEntityTypeContexts, LoadingSessionContext sessionContext, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
        if (targetEntityTypeContexts.size() == 1) {
            LoadingTypeContext<E2> targetEntityTypeContext = targetEntityTypeContexts.iterator().next();
            PojoSelectionEntityLoader<?> result = this.doCreate(targetEntityTypeContext.entityMappingType(), sessionContext, cacheLookupStrategy, loadingOptions);
            return result;
        }
        EntityMappingType commonSuperType = HibernateOrmEntityIdEntityLoadingStrategy.toMostSpecificCommonEntitySuperType(targetEntityTypeContexts);
        if (commonSuperType == null) {
            throw this.invalidTypesException(targetEntityTypeContexts);
        }
        PojoSelectionEntityLoader<?> result = this.doCreate(commonSuperType, sessionContext, cacheLookupStrategy, loadingOptions);
        return result;
    }

    private PojoSelectionEntityLoader<?> doCreate(EntityMappingType entityMappingType, LoadingSessionContext sessionContext, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
        EntityLoadingCacheLookupStrategyImplementor cacheLookupStrategyImplementor;
        if (!this.rootEntityMappingType.getJavaType().getJavaTypeClass().isAssignableFrom(entityMappingType.getJavaType().getJavaTypeClass())) {
            throw this.invalidTypeException(entityMappingType);
        }
        SessionImplementor session = sessionContext.session();
        PersistenceContextLookupStrategy persistenceContextLookup = PersistenceContextLookupStrategy.create(session);
        switch (cacheLookupStrategy) {
            case SKIP: {
                cacheLookupStrategyImplementor = null;
                break;
            }
            case PERSISTENCE_CONTEXT: {
                cacheLookupStrategyImplementor = persistenceContextLookup;
                break;
            }
            case PERSISTENCE_CONTEXT_THEN_SECOND_LEVEL_CACHE: {
                cacheLookupStrategyImplementor = PersistenceContextThenSecondLevelCacheLookupStrategy.create(this.rootEntityMappingType, session);
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected cache lookup strategy: " + (Object)((Object)cacheLookupStrategy));
            }
        }
        return new HibernateOrmSelectionEntityByIdLoader<E>(this.rootEntityMappingType, this.queryFactory, sessionContext, persistenceContextLookup, cacheLookupStrategyImplementor, loadingOptions);
    }

    private static EntityMappingType toMostSpecificCommonEntitySuperType(Iterable<? extends LoadingTypeContext<?>> targetEntityTypeContexts) {
        EntityMappingType result = null;
        for (LoadingTypeContext<?> targetTypeContext : targetEntityTypeContexts) {
            EntityMappingType type = targetTypeContext.entityMappingType();
            if (result == null) {
                result = type;
                continue;
            }
            result = HibernateOrmUtils.toMostSpecificCommonEntitySuperType(result, type);
        }
        return result;
    }

    private AssertionFailure invalidTypeException(EntityMappingType otherEntityMappingType) {
        throw new AssertionFailure("The targeted entity type is not a subclass of the expected root entity type. Expected root entity name: " + this.rootEntityMappingType.getEntityName() + " Targeted entity name: " + otherEntityMappingType.getEntityName());
    }

    private AssertionFailure invalidTypesException(Set<? extends LoadingTypeContext<?>> targetEntityTypeContexts) {
        return new AssertionFailure("Some types among the targeted entity types are not subclasses of the expected root entity type. Expected entity name: " + this.rootEntityMappingType.getEntityName() + " Targeted entity names: " + targetEntityTypeContexts.stream().map(LoadingTypeContext::entityMappingType).map(EntityMappingType::getEntityName).collect(Collectors.toList()));
    }
}

