/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.index.impl;

import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessorImpl;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderProvider;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterConfigSource;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterProvider;
import org.hibernate.search.backend.lucene.resources.impl.BackendThreads;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.reporting.EventContext;

public abstract class IOStrategy {
    final BackendThreads threads;
    final FailureHandler failureHandler;

    protected IOStrategy(BackendThreads threads, FailureHandler failureHandler) {
        this.threads = threads;
        this.failureHandler = failureHandler;
    }

    public IndexAccessorImpl createIndexAccessor(String indexName, EventContext eventContext, DirectoryHolder directoryHolder, IndexWriterConfigSource writerConfigSource) {
        IndexWriterProvider indexWriterProvider = null;
        IndexReaderProvider indexReaderProvider = null;
        try {
            indexWriterProvider = this.createIndexWriterProvider(indexName, eventContext, directoryHolder, writerConfigSource);
            indexReaderProvider = this.createIndexReaderProvider(directoryHolder, indexWriterProvider);
            return new IndexAccessorImpl(eventContext, directoryHolder, indexWriterProvider, indexReaderProvider);
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)((SuppressingCloser)new SuppressingCloser((Throwable)e).push(IndexWriterProvider::clear, (Object)indexWriterProvider)).push(IndexReaderProvider::clear, (Object)indexReaderProvider)).push((AutoCloseable)directoryHolder);
            throw e;
        }
    }

    abstract IndexWriterProvider createIndexWriterProvider(String var1, EventContext var2, DirectoryHolder var3, IndexWriterConfigSource var4);

    abstract IndexReaderProvider createIndexReaderProvider(DirectoryHolder var1, IndexWriterProvider var2);
}

