/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.util.concurrent.Executor;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.EJBClientContext;
import org.wildfly.common.context.Contextual;
import org.wildfly.discovery.Discovery;
import org.wildfly.security.auth.client.AuthenticationContext;

class RetryExecutorWrapper {
    private final Object lock = new Object();
    private Task last = null;

    RetryExecutorWrapper() {
    }

    Executor getExecutor(Executor executor) {
        if (Logs.INVOCATION.isTraceEnabled()) {
            Logs.INVOCATION.tracef("RetryExecutorWrapper: calling getExecutor(executor= %s)", executor.getClass().getName());
        }
        return runnable -> {
            Object object = this.lock;
            synchronized (object) {
                Task task = new Task(runnable, executor);
                if (this.last != null) {
                    this.last.next = task;
                    this.last = task;
                } else {
                    this.last = task;
                    executor.execute(task);
                }
            }
        };
    }

    Executor getExecutor(Executor executor, EJBClientContext ejbClientContext, Discovery discovery, AuthenticationContext authenticationContext) {
        if (Logs.INVOCATION.isTraceEnabled()) {
            Logs.INVOCATION.tracef("RetryExecutorWrapper: calling getExecutor(executor= %s, ejbClientContext = %s, discovery = %s, authenticationContext = %s)", new Object[]{executor.getClass().getName(), ejbClientContext, discovery, authenticationContext});
        }
        return runnable -> {
            Object object = this.lock;
            synchronized (object) {
                Runnable runnableWithContext = this.wrapExecutorThreadWithCallerContext(runnable, ejbClientContext, discovery, authenticationContext);
                Task task = new Task(runnableWithContext, executor);
                if (this.last != null) {
                    this.last.next = task;
                    this.last = task;
                } else {
                    this.last = task;
                    executor.execute(task);
                }
            }
        };
    }

    private Runnable wrapExecutorThreadWithCallerContext(Runnable runnable, EJBClientContext callerEJBClientContext, Discovery callerDiscovery, AuthenticationContext callerAuthenticationContext) {
        Runnable callerContextTask = () -> {
            EJBClientContext executorEJBClientContext = (EJBClientContext)EJBClientContext.getContextManager().getThreadDefault();
            Discovery executorDiscovery = (Discovery)Discovery.getContextManager().getThreadDefault();
            AuthenticationContext executorAuthenticationContext = (AuthenticationContext)AuthenticationContext.getContextManager().getThreadDefault();
            EJBClientContext.getContextManager().setThreadDefault((Contextual)callerEJBClientContext);
            Discovery.getContextManager().setThreadDefault((Contextual)callerDiscovery);
            AuthenticationContext.getContextManager().setThreadDefault((Contextual)callerAuthenticationContext);
            runnable.run();
            EJBClientContext.getContextManager().setThreadDefault((Contextual)executorEJBClientContext);
            Discovery.getContextManager().setThreadDefault((Contextual)executorDiscovery);
            AuthenticationContext.getContextManager().setThreadDefault((Contextual)executorAuthenticationContext);
        };
        return callerContextTask;
    }

    private class Task
    implements Runnable {
        private final Runnable runnable;
        private final Executor delegate;
        private Task next;

        private Task(Runnable runnable, Executor delegate) {
            this.runnable = runnable;
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                Logs.MAIN.taskFailed(this.runnable, t);
            }
            finally {
                Object object = RetryExecutorWrapper.this.lock;
                synchronized (object) {
                    if (RetryExecutorWrapper.this.last == this) {
                        RetryExecutorWrapper.this.last = null;
                    }
                    if (this.next != null) {
                        this.next.delegate.execute(this.next);
                    }
                }
            }
        }
    }
}

