/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.compiler;

import com.sun.faces.config.FaceletsConfiguration;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.compiler.CompilationManager;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.compiler.EncodingHandler;
import com.sun.faces.facelets.tag.TagAttributeImpl;
import com.sun.faces.facelets.tag.TagAttributesImpl;
import com.sun.faces.facelets.tag.faces.core.CoreLibrary;
import com.sun.faces.util.Util;
import jakarta.faces.component.html.HtmlDoctype;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.Location;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.FaceletHandler;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributes;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXCompiler
extends Compiler {
    private static final Pattern XmlDeclaration = Pattern.compile("^<\\?xml.+?version=['\"](.+?)['\"](.+?encoding=['\"]((.+?))['\"])?.*?\\?>");

    @Override
    public FaceletHandler doCompile(URL src, String alias) throws IOException {
        CompilationManager mgr = new CompilationManager(alias, this);
        CompilationHandler handler = new CompilationHandler(mgr, alias);
        return this.doCompile(mgr, handler, src, alias);
    }

    @Override
    public FaceletHandler doMetadataCompile(URL src, String alias) throws IOException {
        CompilationManager mgr = new CompilationManager("metadata/" + alias, this);
        MetadataCompilationHandler handler = new MetadataCompilationHandler(mgr, alias);
        return this.doCompile(mgr, handler, src, alias);
    }

    protected FaceletHandler doCompile(CompilationManager mngr, CompilationHandler handler, URL src, String alias) throws IOException {
        String encoding = this.getEncoding();
        try (BufferedInputStream is = new BufferedInputStream(src.openStream(), 1024);){
            SAXCompiler.writeXmlDecl(is, encoding, mngr);
            SAXParser parser = this.createSAXParser(handler);
            parser.parse((InputStream)is, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw new FaceletException("Error Parsing " + alias + ": " + e.getMessage(), e.getCause());
        }
        catch (ParserConfigurationException e) {
            throw new FaceletException("Error Configuring Parser " + alias + ": " + e.getMessage(), e.getCause());
        }
        catch (FaceletException e) {
            throw e;
        }
        EncodingHandler result = new EncodingHandler(mngr.createFaceletHandler(), encoding, mngr.getCompilationMessageHolder());
        mngr.setCompilationMessageHolder(null);
        return result;
    }

    private String getEncoding() {
        String encodingFromRequest = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (null != context) {
            ExternalContext extContext = context.getExternalContext();
            encodingFromRequest = extContext.getRequestCharacterEncoding();
        }
        String result = null != encodingFromRequest ? encodingFromRequest : "UTF-8";
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeXmlDecl(InputStream is, String encoding, CompilationManager mngr) throws IOException {
        is.mark(128);
        try {
            WebConfiguration config;
            FaceletsConfiguration faceletsConfig;
            boolean currentModeIsXhtml;
            String r;
            Matcher m;
            byte[] b = new byte[128];
            if (is.read(b) > 0 && (m = XmlDeclaration.matcher(r = new String(b, encoding))).find() && (currentModeIsXhtml = (faceletsConfig = (config = mngr.getWebConfiguration()).getFaceletsConfiguration()).isProcessCurrentDocumentAsFaceletsXhtml(mngr.getAlias()))) {
                Util.saveXMLDECLToFacesContextAttributes(m.group(0) + "\n");
            }
        }
        finally {
            is.reset();
        }
    }

    private SAXParser createSAXParser(CompilationHandler handler) throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = Util.createSAXParserFactory();
        factory.setNamespaceAware(true);
        factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        factory.setFeature("http://xml.org/sax/features/validation", this.isValidating());
        factory.setValidating(this.isValidating());
        if (handler.isDisallowDoctypeDeclSet()) {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", handler.isDisallowDoctypeDecl());
        }
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        reader.setErrorHandler(handler);
        reader.setEntityResolver(handler);
        return parser;
    }

    private static class MetadataCompilationHandler
    extends CompilationHandler {
        private static final String METADATA_HANDLER = "metadata";
        private boolean processingMetadata = false;
        private boolean metadataProcessed = false;

        public MetadataCompilationHandler(CompilationManager unit, String alias) {
            super(unit, alias);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.metadataProcessed && this.processingMetadata) {
                this.unit.writeText(new String(ch, start, length));
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!this.metadataProcessed) {
                if (!this.processingMetadata && CoreLibrary.NAMESPACES.contains(uri) && METADATA_HANDLER.equals(localName)) {
                    this.processingMetadata = true;
                }
                if (this.processingMetadata) {
                    super.startElement(uri, localName, qName, attributes);
                }
            }
            if (localName.equals("view") && CoreLibrary.NAMESPACES.contains(uri)) {
                super.startElement(uri, localName, qName, attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.metadataProcessed) {
                if (this.processingMetadata) {
                    super.endElement(uri, localName, qName);
                }
                if (this.processingMetadata && CoreLibrary.NAMESPACES.contains(uri) && METADATA_HANDLER.equals(localName)) {
                    this.processingMetadata = false;
                    this.metadataProcessed = true;
                }
            }
            if (localName.equals("view") && CoreLibrary.NAMESPACES.contains(uri)) {
                super.endElement(uri, localName, qName);
            }
        }
    }

    private static class CompilationHandler
    extends DefaultHandler
    implements LexicalHandler {
        protected final String alias;
        protected boolean inDocument = false;
        protected Locator locator;
        protected final CompilationManager unit;

        public CompilationHandler(CompilationManager unit, String alias) {
            this.unit = unit;
            this.alias = alias;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument) {
                this.unit.writeText(new String(ch, start, length));
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && !this.unit.getWebConfiguration().getFaceletsConfiguration().isConsumeComments(this.alias)) {
                this.unit.writeComment(new String(ch, start, length));
            }
        }

        protected TagAttributesImpl createAttributes(Attributes attrs) {
            int len = attrs.getLength();
            TagAttribute[] ta = new TagAttributeImpl[len];
            for (int i = 0; i < len; ++i) {
                ta[i] = new TagAttributeImpl(this.createLocation(), attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getValue(i));
            }
            return new TagAttributesImpl(ta);
        }

        protected Location createLocation() {
            Location result = null;
            if (null != this.locator) {
                result = new Location(this.alias, this.locator.getLineNumber(), this.locator.getColumnNumber());
            } else if (Compiler.log.isLoggable(Level.SEVERE)) {
                Compiler.log.log(Level.SEVERE, "Unable to create Location due to null locator instance variable.");
            }
            return result;
        }

        @Override
        public void endCDATA() throws SAXException {
            if (this.inDocument && !this.unit.getWebConfiguration().getFaceletsConfiguration().isConsumeCDATA(this.alias)) {
                this.unit.writeInstruction("]]>");
            }
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
        }

        @Override
        public void endDTD() throws SAXException {
            this.inDocument = true;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.unit.popTag();
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.unit.popNamespace(prefix);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            if (this.locator != null) {
                throw new SAXException("Error Traced[line: " + this.locator.getLineNumber() + "] " + e.getMessage());
            }
            throw e;
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument) {
                this.unit.writeWhitespace(new String(ch, start, length));
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            String dtd = "com/sun/faces/xhtml/default.dtd";
            URL url = this.getClass().getClassLoader().getResource(dtd);
            return new InputSource(url.toString());
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startCDATA() throws SAXException {
            if (this.inDocument && !this.unit.getWebConfiguration().getFaceletsConfiguration().isConsumeCDATA(this.alias)) {
                this.unit.writeInstruction("<![CDATA[");
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.inDocument = true;
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            FaceletsConfiguration facelets = this.unit.getWebConfiguration().getFaceletsConfiguration();
            boolean processAsXhtml = facelets.isProcessCurrentDocumentAsFaceletsXhtml(this.alias);
            boolean outputAsHtml5 = facelets.isOutputHtml5Doctype(this.alias);
            if (this.inDocument && (processAsXhtml || outputAsHtml5)) {
                HtmlDoctype doctype = new HtmlDoctype();
                doctype.setRootElement(name);
                if (!outputAsHtml5) {
                    doctype.setPublic(publicId);
                    doctype.setSystem(systemId);
                }
                Util.saveDOCTYPEToFacesContextAttributes(doctype);
            }
            this.inDocument = false;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            TagAttributesImpl tagAttrs = this.createAttributes(attributes);
            Tag tag = new Tag(this.createLocation(), uri, localName, qName, tagAttrs);
            ((TagAttributes)tagAttrs).setTag(tag);
            this.unit.pushTag(tag);
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.unit.pushNamespace(prefix, uri);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            boolean processAsXhtml;
            if (this.inDocument && (processAsXhtml = this.unit.getWebConfiguration().getFaceletsConfiguration().isProcessCurrentDocumentAsFaceletsXhtml(this.alias))) {
                StringBuffer sb = new StringBuffer(64);
                sb.append("<?").append(target).append(' ').append(data).append("?>\n");
                this.unit.writeInstruction(sb.toString());
            }
        }

        protected boolean isDisallowDoctypeDeclSet() {
            return this.unit.getWebConfiguration().isSet(WebConfiguration.BooleanWebContextInitParameter.DisallowDoctypeDecl);
        }

        protected boolean isDisallowDoctypeDecl() {
            return this.unit.getWebConfiguration().isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisallowDoctypeDecl);
        }
    }
}

