/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.controller.PathAddress;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.web.service.routing.RoutingProvider;
import org.wildfly.extension.clustering.web.RoutingProviderResourceDefinition;

public abstract class RoutingProviderServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
Supplier<RoutingProvider> {
    private final ServiceName alias;

    public RoutingProviderServiceConfigurator(PathAddress address) {
        this(address, null);
    }

    public RoutingProviderServiceConfigurator(PathAddress address, ServiceName alias) {
        super((Capability)RoutingProviderResourceDefinition.Capability.ROUTING_PROVIDER, address);
        this.alias = alias;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName[] serviceNameArray;
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(this.getServiceName());
        if (this.alias != null) {
            ServiceName[] serviceNameArray2 = new ServiceName[2];
            serviceNameArray2[0] = name;
            serviceNameArray = serviceNameArray2;
            serviceNameArray2[1] = this.alias;
        } else {
            ServiceName[] serviceNameArray3 = new ServiceName[1];
            serviceNameArray = serviceNameArray3;
            serviceNameArray3[0] = name;
        }
        Consumer provider = builder.provides(serviceNameArray);
        FunctionalService service = new FunctionalService(provider, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

