/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.test.integration.security.jacc.context;

import jakarta.ejb.Stateless;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.servlet.http.HttpServletRequest;

@Stateless
public class PolicyContextTestBean {

    public HttpServletRequest getHttpServletRequestFromPolicyContext() throws PolicyContextException {
        return getHttpServletRequest();
    }

    // public as accessed from a different module.
    public static HttpServletRequest getHttpServletRequest() throws PolicyContextException {
        HttpServletRequest httpServletRequest = (HttpServletRequest) PolicyContext
                .getContext("jakarta.servlet.http.HttpServletRequest");
        return httpServletRequest;
    }
}
