/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.SecurityException;
import jakarta.resource.spi.security.PasswordCredential;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionRequestInfo;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;

public class ActiveMQRACredential
implements Serializable {
    static final long serialVersionUID = 210476602237497193L;
    private String userName;
    private String password;

    private ActiveMQRACredential() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("constructor()");
        }
    }

    public String getUserName() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getUserName()");
        }
        return this.userName;
    }

    private void setUserName(String userName) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setUserName(" + userName + ")");
        }
        this.userName = userName;
    }

    public String getPassword() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getPassword()");
        }
        return this.password;
    }

    private void setPassword(String password) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setPassword(****)");
        }
        this.password = password;
    }

    public static ActiveMQRACredential getCredential(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) throws SecurityException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getCredential(" + mcf + ", " + subject + ", " + info + ")");
        }
        ActiveMQRACredential jc = new ActiveMQRACredential();
        if (subject == null && info != null) {
            jc.setUserName(((ActiveMQRAConnectionRequestInfo)info).getUserName());
            jc.setPassword(((ActiveMQRAConnectionRequestInfo)info).getPassword());
        } else if (subject != null) {
            PasswordCredential pwdc = GetCredentialAction.getCredential(subject, mcf);
            if (pwdc == null) {
                throw new SecurityException("No password credentials found");
            }
            jc.setUserName(pwdc.getUserName());
            jc.setPassword(new String(pwdc.getPassword()));
        } else {
            throw new SecurityException("No Subject or ConnectionRequestInfo set, could not get credentials");
        }
        return jc;
    }

    public String toString() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("toString()");
        }
        return super.toString() + "{ username=" + this.userName + ", password=**** }";
    }

    private static class GetCredentialAction
    implements PrivilegedAction<PasswordCredential> {
        private final Subject subject;
        private final ManagedConnectionFactory mcf;

        GetCredentialAction(Subject subject, ManagedConnectionFactory mcf) {
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("constructor(" + subject + ", " + mcf + ")");
            }
            this.subject = subject;
            this.mcf = mcf;
        }

        @Override
        public PasswordCredential run() {
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("run()");
            }
            Set<PasswordCredential> creds = this.subject.getPrivateCredentials(PasswordCredential.class);
            PasswordCredential pwdc = null;
            for (PasswordCredential curCred : creds) {
                if (!curCred.getManagedConnectionFactory().equals((Object)this.mcf)) continue;
                pwdc = curCred;
                break;
            }
            return pwdc;
        }

        static PasswordCredential getCredential(Subject subject, ManagedConnectionFactory mcf) {
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("getCredential(" + subject + ", " + mcf + ")");
            }
            GetCredentialAction action = new GetCredentialAction(subject, mcf);
            return AccessController.doPrivileged(action);
        }
    }
}

