/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.util;

import java.util.Map;
import java.util.Set;
import org.jboss.vfs.VFSLogger;
import org.jboss.vfs.VFSMessages;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

public class FileNameVirtualFileFilter
implements VirtualFileFilter {
    private Map<String, Set<String>> excludes;

    public FileNameVirtualFileFilter(Map<String, Set<String>> excludes) {
        if (excludes == null || excludes.isEmpty()) {
            throw VFSMessages.MESSAGES.nullOrEmpty("excludes");
        }
        this.excludes = excludes;
    }

    @Override
    public boolean accepts(VirtualFile file) {
        String pathName = this.getPathName(file);
        for (Map.Entry<String, Set<String>> entry : this.excludes.entrySet()) {
            String key = entry.getKey();
            if (!pathName.contains(key)) continue;
            String simpleName = file.getName();
            Set<String> value = entry.getValue();
            if (value != null && !value.contains(simpleName)) continue;
            VFSLogger.ROOT_LOGGER.tracef("Excluding %s", pathName);
            return false;
        }
        return true;
    }

    protected String getPathName(VirtualFile file) {
        try {
            return file.toURI().toString();
        }
        catch (Exception e) {
            return file.getPathName();
        }
    }
}

