/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationClassValue;
import com.sun.codemodel.JAnnotationStringValue;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JType;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JAnnotationUse
extends JAnnotationValue {
    private final JClass clazz;
    private Map<String, JAnnotationValue> memberValues;

    JAnnotationUse(JClass clazz) {
        this.clazz = clazz;
    }

    public JClass getAnnotationClass() {
        return this.clazz;
    }

    public Map<String, JAnnotationValue> getAnnotationMembers() {
        if (this.memberValues == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.memberValues);
    }

    private JCodeModel owner() {
        return this.clazz.owner();
    }

    private void addValue(String name, JAnnotationValue annotationValue) {
        if (this.memberValues == null) {
            this.memberValues = new LinkedHashMap<String, JAnnotationValue>();
        }
        this.memberValues.put(name, annotationValue);
    }

    public JAnnotationUse param(String name, boolean value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, byte value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, char value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, double value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, float value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, long value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, short value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, int value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, String value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse annotationParam(String name, Class<? extends Annotation> value) {
        JAnnotationUse annotationUse = new JAnnotationUse(this.owner().ref(value));
        this.addValue(name, annotationUse);
        return annotationUse;
    }

    public JAnnotationUse param(String name, Enum<?> value) {
        JClass ref = this.owner().ref(value.getClass());
        return this.param(name, new JEnumConstant(ref, value.name()));
    }

    public JAnnotationUse param(String name, JEnumConstant value) {
        this.addValue(name, new JAnnotationClassValue(value));
        return this;
    }

    public JAnnotationUse param(String name, Class<?> value) {
        this.addValue(name, new JAnnotationClassValue(this.owner().ref(value)));
        return this;
    }

    public JAnnotationUse param(String name, JType type) {
        JClass c = type.boxify();
        this.addValue(name, new JAnnotationClassValue(c));
        return this;
    }

    public JAnnotationUse param(String name, JExpression value) {
        this.addValue(name, new JAnnotationStringValue(value));
        return this;
    }

    public JAnnotationArrayMember paramArray(String name) {
        JAnnotationArrayMember arrayMember = new JAnnotationArrayMember(this.owner());
        this.addValue(name, arrayMember);
        return arrayMember;
    }

    @Deprecated
    public JAnnotationUse annotate(Class<? extends Annotation> clazz) {
        return new JAnnotationUse(this.owner().ref(clazz));
    }

    @Override
    public void generate(JFormatter f) {
        f.p('@').g(this.clazz);
        if (this.memberValues != null) {
            f.p('(');
            boolean first = true;
            if (this.isOptimizable()) {
                f.g(this.memberValues.get("value"));
            } else {
                for (Map.Entry<String, JAnnotationValue> mapEntry : this.memberValues.entrySet()) {
                    if (!first) {
                        f.p(',');
                    }
                    f.p(mapEntry.getKey()).p('=').g(mapEntry.getValue());
                    first = false;
                }
            }
            f.p(')');
        }
    }

    private boolean isOptimizable() {
        return this.memberValues.size() == 1 && this.memberValues.containsKey("value");
    }
}

