/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.echo;

import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.command.shell.Shell;

@CommandDefinition(name="echo", description="Echo the STRING(s) to standard output.")
public class Echo
implements Command<CommandInvocation> {
    @Option(shortName=104, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Arguments
    private List<String> arguments;

    public CommandResult execute(CommandInvocation commandInvocation) {
        Shell shell = commandInvocation.getShell();
        if (this.help || this.arguments == null || this.arguments.isEmpty()) {
            shell.writeln(commandInvocation.getHelpInfo("echo"));
            return CommandResult.SUCCESS;
        }
        String stdout = "";
        for (String s : this.arguments) {
            stdout = stdout + s + " ";
        }
        stdout = stdout.trim();
        commandInvocation.println(stdout);
        return CommandResult.SUCCESS;
    }
}

