/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.OperationContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.extension.messaging.activemq.SecurityRoleDefinition;

public class ManagementUtil {
    public static void reportRolesAsJSON(OperationContext context, String rolesAsJSON) {
        ModelNode camelCase = ModelNode.fromJSONString((String)rolesAsJSON);
        ModelNode converted = ManagementUtil.convertSecurityRole(camelCase);
        String json = converted.toJSONString(true);
        context.getResult().set(json);
    }

    public static void reportRoles(OperationContext context, Object[] roles) {
        context.getResult().set(ManagementUtil.convertRoles(roles));
    }

    public static ModelNode convertRoles(Object[] roles) {
        ModelNode result = new ModelNode();
        result.setEmptyList();
        if (roles != null && roles.length > 0) {
            for (Object objRole : roles) {
                Object[] role = (Object[])objRole;
                ModelNode roleNode = result.add();
                roleNode.get("name").set(role[0].toString());
                roleNode.get(SecurityRoleDefinition.SEND.getName()).set(((Boolean)role[1]).booleanValue());
                roleNode.get(SecurityRoleDefinition.CONSUME.getName()).set(((Boolean)role[2]).booleanValue());
                roleNode.get(SecurityRoleDefinition.CREATE_DURABLE_QUEUE.getName()).set(((Boolean)role[3]).booleanValue());
                roleNode.get(SecurityRoleDefinition.DELETE_DURABLE_QUEUE.getName()).set(((Boolean)role[4]).booleanValue());
                roleNode.get(SecurityRoleDefinition.CREATE_NON_DURABLE_QUEUE.getName()).set(((Boolean)role[5]).booleanValue());
                roleNode.get(SecurityRoleDefinition.DELETE_NON_DURABLE_QUEUE.getName()).set(((Boolean)role[6]).booleanValue());
                roleNode.get(SecurityRoleDefinition.MANAGE.getName()).set(((Boolean)role[7]).booleanValue());
                roleNode.get(SecurityRoleDefinition.BROWSE.getName()).set(((Boolean)role[8]).booleanValue());
                roleNode.get(SecurityRoleDefinition.CREATE_ADDRESS.getName()).set(((Boolean)role[9]).booleanValue());
                roleNode.get(SecurityRoleDefinition.DELETE_ADDRESS.getName()).set(((Boolean)role[10]).booleanValue());
            }
        }
        return result;
    }

    public static void reportListOfStrings(OperationContext context, String[] strings) {
        ModelNode result = context.getResult();
        result.setEmptyList();
        for (String str : strings) {
            result.add(str);
        }
    }

    private ManagementUtil() {
    }

    static ModelNode convertSecurityRole(ModelNode camelCase) {
        ModelNode result = new ModelNode();
        result.setEmptyList();
        if (camelCase.isDefined()) {
            for (ModelNode role : camelCase.asList()) {
                ModelNode roleNode = result.add();
                for (Property prop : role.asPropertyList()) {
                    String key = prop.getName();
                    if (null != key) {
                        switch (key) {
                            case "createDurableQueue": {
                                key = SecurityRoleDefinition.CREATE_DURABLE_QUEUE.getName();
                                break;
                            }
                            case "deleteDurableQueue": {
                                key = SecurityRoleDefinition.DELETE_DURABLE_QUEUE.getName();
                                break;
                            }
                            case "createNonDurableQueue": {
                                key = SecurityRoleDefinition.CREATE_NON_DURABLE_QUEUE.getName();
                                break;
                            }
                            case "deleteNonDurableQueue": {
                                key = SecurityRoleDefinition.DELETE_NON_DURABLE_QUEUE.getName();
                                break;
                            }
                            case "createAddress": {
                                key = "create-address";
                                break;
                            }
                            case "deleteAddress": {
                                key = "delete-address";
                                break;
                            }
                        }
                    }
                    roleNode.get(key).set(prop.getValue());
                }
            }
        }
        return result;
    }
}

