/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.ObjectMessage;
import org.jgroups.Refcountable;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.RED;
import org.jgroups.protocols.TCP;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.UnicastHeader3;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AgeOutCache;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.ExpiryCache;
import org.jgroups.util.LongTuple;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.SeqnoList;
import org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.jgroups.util.Table;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.TimeService;
import org.jgroups.util.Util;

@MBean(description="Reliable unicast layer")
public class UNICAST3
extends Protocol
implements AgeOutCache.Handler<Address> {
    protected static final long DEFAULT_FIRST_SEQNO = 1L;
    protected static final long DEFAULT_XMIT_INTERVAL = 500L;
    @Property(description="Time (in milliseconds) after which an idle incoming or outgoing connection is closed. The connection will get re-established when used again. 0 disables connection reaping. Note that this creates lingering connection entries, which increases memory over time.", type=AttributeType.TIME)
    protected long conn_expiry_timeout = 120000L;
    @Property(description="Time (in ms) until a connection marked to be closed will get removed. 0 disables this", type=AttributeType.TIME)
    protected long conn_close_timeout = 240000L;
    @Property(description="Number of rows of the matrix in the retransmission table (only for experts)", writable=false)
    protected int xmit_table_num_rows = 100;
    @Property(description="Number of elements of a row of the matrix in the retransmission table; gets rounded to the next power of 2 (only for experts). The capacity of the matrix is xmit_table_num_rows * xmit_table_msgs_per_row", writable=false)
    protected int xmit_table_msgs_per_row = 1024;
    @Property(description="Resize factor of the matrix in the retransmission table (only for experts)", writable=false)
    protected double xmit_table_resize_factor = 1.2;
    @Property(description="Number of milliseconds after which the matrix in the retransmission table is compacted (only for experts)", writable=false, type=AttributeType.TIME)
    protected long xmit_table_max_compaction_time = 600000L;
    protected long max_retransmit_time = 60000L;
    @Property(description="Interval (in milliseconds) at which messages in the send windows are resent", type=AttributeType.TIME)
    protected long xmit_interval = 500L;
    @Property(description="When true, the sender retransmits messages until ack'ed and the receiver asks for missing messages. When false, this is not done, but ack'ing and stale connection testing is still done. https://issues.redhat.com/browse/JGRP-2676")
    protected boolean xmits_enabled = true;
    @Property(description="If true, trashes warnings about retransmission messages not found in the xmit_table (used for testing)")
    protected boolean log_not_found_msgs = true;
    @Property(description="Send an ack immediately when a batch of ack_threshold (or more) messages is received. Otherwise send delayed acks. If 1, ack single messages (similar to UNICAST)")
    protected int ack_threshold = 100;
    @Property(description="Min time (in ms) to elapse for successive SEND_FIRST_SEQNO messages to be sent to the same sender", type=AttributeType.TIME)
    protected long sync_min_interval = 2000L;
    @Property(description="Max number of messages to ask for in a retransmit request. 0 disables this and uses the max bundle size in the transport")
    protected int max_xmit_req_size;
    @Property(description="The max size of a message batch when delivering messages. 0 is unbounded")
    protected int max_batch_size;
    @Property(description="If true, a unicast message to self is looped back up on the same thread. Noter that this may cause problems (e.g. deadlocks) in some applications, so make sure that your code can handle this. Issue: https://issues.redhat.com/browse/JGRP-2547")
    protected boolean loopback;
    protected long num_msgs_sent = 0L;
    protected long num_msgs_received = 0L;
    protected long num_acks_sent = 0L;
    protected long num_acks_received = 0L;
    protected long num_xmits = 0L;
    @ManagedAttribute(description="Number of retransmit requests received", type=AttributeType.SCALAR)
    protected final LongAdder xmit_reqs_received = new LongAdder();
    @ManagedAttribute(description="Number of retransmit requests sent", type=AttributeType.SCALAR)
    protected final LongAdder xmit_reqs_sent = new LongAdder();
    @ManagedAttribute(description="Number of retransmit responses sent", type=AttributeType.SCALAR)
    protected final LongAdder xmit_rsps_sent = new LongAdder();
    @ManagedAttribute(description="Average batch size of messages delivered to the application")
    protected final AverageMinMax avg_delivery_batch_size = new AverageMinMax();
    @ManagedAttribute(description="True if sending a message can block at the transport level")
    protected boolean sends_can_block = true;
    @ManagedAttribute(description="tracing is enabled or disabled for the given log", writable=true)
    protected boolean is_trace = this.log.isTraceEnabled();
    protected final ConcurrentMap<Address, SenderEntry> send_table = Util.createConcurrentMap();
    protected final ConcurrentMap<Address, ReceiverEntry> recv_table = Util.createConcurrentMap();
    protected final ReentrantLock recv_table_lock = new ReentrantLock();
    protected final Map<Address, Long> xmit_task_map = new HashMap<Address, Long>();
    protected Future<?> xmit_task;
    protected volatile List<Address> members = new ArrayList<Address>(11);
    protected TimeScheduler timer;
    protected volatile boolean running = false;
    protected short last_conn_id;
    protected AgeOutCache<Address> cache;
    protected TimeService time_service;
    protected final AtomicInteger timestamper = new AtomicInteger(0);
    protected ExpiryCache<Address> last_sync_sent;
    protected final LongAdder loopbed_back_msgs = new LongAdder();
    protected final MessageCache msg_cache = new MessageCache();
    protected static final Message DUMMY_OOB_MSG = new EmptyMessage().setFlag(Message.Flag.OOB);
    protected final Predicate<Message> drop_oob_and_dont_loopback_msgs_filter = msg -> !(msg == null || msg == DUMMY_OOB_MSG || msg.isFlagSet(Message.Flag.OOB) && !msg.setFlagIfAbsent(Message.TransientFlag.OOB_DELIVERED) || msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK) && Objects.equals(this.local_addr, msg.getSrc()));
    protected static final Predicate<Message> dont_loopback_filter = m -> m != null && (m.isFlagSet(Message.TransientFlag.DONT_LOOPBACK) || m == DUMMY_OOB_MSG || m.isFlagSet(Message.TransientFlag.OOB_DELIVERED));
    protected static final BiConsumer<MessageBatch, Message> BATCH_ACCUMULATOR = MessageBatch::add;
    protected static final Table.Visitor<Message> DECR = (seqno, msg, row, col) -> {
        if (msg instanceof Refcountable) {
            ((Refcountable)((Object)msg)).decr();
        }
        return true;
    };

    @ManagedAttribute(description="Number of unicast messages to self looped back up", type=AttributeType.SCALAR)
    public long getNumLoopbacks() {
        return this.loopbed_back_msgs.sum();
    }

    @ManagedAttribute(description="Returns the number of outgoing (send) connections")
    public int getNumSendConnections() {
        return this.send_table.size();
    }

    @ManagedAttribute(description="Returns the number of incoming (receive) connections")
    public int getNumReceiveConnections() {
        return this.recv_table.size();
    }

    @ManagedAttribute(description="Returns the total number of outgoing (send) and incoming (receive) connections")
    public int getNumConnections() {
        return this.getNumReceiveConnections() + this.getNumSendConnections();
    }

    @ManagedAttribute(description="Next seqno issued by the timestamper")
    public int getTimestamper() {
        return this.timestamper.get();
    }

    public int getAckThreshold() {
        return this.ack_threshold;
    }

    public UNICAST3 setAckThreshold(int a) {
        this.ack_threshold = a;
        return this;
    }

    @Override
    @Property(name="level", description="Sets the level")
    public <T extends Protocol> T setLevel(String level) {
        Object retval = super.setLevel(level);
        this.is_trace = this.log.isTraceEnabled();
        return retval;
    }

    public long getXmitInterval() {
        return this.xmit_interval;
    }

    public UNICAST3 setXmitInterval(long i) {
        this.xmit_interval = i;
        return this;
    }

    public boolean isXmitsEnabled() {
        return this.xmits_enabled;
    }

    public UNICAST3 setXmitsEnabled(boolean b) {
        this.xmits_enabled = b;
        return this;
    }

    public int getXmitTableNumRows() {
        return this.xmit_table_num_rows;
    }

    public UNICAST3 setXmitTableNumRows(int n) {
        this.xmit_table_num_rows = n;
        return this;
    }

    public int getXmitTableMsgsPerRow() {
        return this.xmit_table_msgs_per_row;
    }

    public UNICAST3 setXmitTableMsgsPerRow(int n) {
        this.xmit_table_msgs_per_row = n;
        return this;
    }

    public long getConnExpiryTimeout() {
        return this.conn_expiry_timeout;
    }

    public UNICAST3 setConnExpiryTimeout(long c) {
        this.conn_expiry_timeout = c;
        return this;
    }

    public long getConnCloseTimeout() {
        return this.conn_close_timeout;
    }

    public UNICAST3 setConnCloseTimeout(long c) {
        this.conn_close_timeout = c;
        return this;
    }

    public double getXmitTableResizeFactor() {
        return this.xmit_table_resize_factor;
    }

    public UNICAST3 setXmitTableResizeFactor(double x) {
        this.xmit_table_resize_factor = x;
        return this;
    }

    public long getXmitTableMaxCompactionTime() {
        return this.xmit_table_max_compaction_time;
    }

    public UNICAST3 setXmitTableMaxCompactionTime(long x) {
        this.xmit_table_max_compaction_time = x;
        return this;
    }

    public boolean logNotFoundMsgs() {
        return this.log_not_found_msgs;
    }

    public UNICAST3 logNotFoundMsgs(boolean l) {
        this.log_not_found_msgs = l;
        return this;
    }

    public long getSyncMinInterval() {
        return this.sync_min_interval;
    }

    public UNICAST3 setSyncMinInterval(long s) {
        this.sync_min_interval = s;
        return this;
    }

    public int getMaxXmitReqSize() {
        return this.max_xmit_req_size;
    }

    public UNICAST3 setMaxXmitReqSize(int m) {
        this.max_xmit_req_size = m;
        return this;
    }

    public boolean sendsCanBlock() {
        return this.sends_can_block;
    }

    public UNICAST3 sendsCanBlock(boolean s) {
        this.sends_can_block = s;
        return this;
    }

    @ManagedOperation
    public String printConnections() {
        StringBuilder sb = new StringBuilder();
        if (!this.send_table.isEmpty()) {
            sb.append("\nsend connections:\n");
            for (Map.Entry entry : this.send_table.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        if (!this.recv_table.isEmpty()) {
            sb.append("\nreceive connections:\n");
            for (Map.Entry entry : this.recv_table.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    @ManagedAttribute(type=AttributeType.SCALAR)
    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    @ManagedAttribute(type=AttributeType.SCALAR)
    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    @ManagedAttribute(type=AttributeType.SCALAR)
    public long getNumAcksSent() {
        return this.num_acks_sent;
    }

    @ManagedAttribute(type=AttributeType.SCALAR)
    public long getNumAcksReceived() {
        return this.num_acks_received;
    }

    @ManagedAttribute(type=AttributeType.SCALAR)
    public long getNumXmits() {
        return this.num_xmits;
    }

    public long getMaxRetransmitTime() {
        return this.max_retransmit_time;
    }

    @Property(description="Max number of milliseconds we try to retransmit a message to any given member. After that, the connection is removed. Any new connection to that member will start with seqno #1 again. 0 disables this", type=AttributeType.TIME)
    public UNICAST3 setMaxRetransmitTime(long max_retransmit_time) {
        this.max_retransmit_time = max_retransmit_time;
        if (this.cache != null && max_retransmit_time > 0L) {
            this.cache.setTimeout(max_retransmit_time);
        }
        return this;
    }

    @ManagedAttribute(description="Is the retransmit task running")
    public boolean isXmitTaskRunning() {
        return this.xmit_task != null && !this.xmit_task.isDone();
    }

    @ManagedAttribute
    public int getAgeOutCacheSize() {
        return this.cache != null ? this.cache.size() : 0;
    }

    @ManagedOperation
    public String printAgeOutCache() {
        return this.cache != null ? this.cache.toString() : "n/a";
    }

    public AgeOutCache<Address> getAgeOutCache() {
        return this.cache;
    }

    public boolean hasSendConnectionTo(Address dest) {
        Entry entry = (Entry)this.send_table.get(dest);
        return entry != null && entry.state() == State.OPEN;
    }

    @ManagedAttribute(type=AttributeType.SCALAR)
    public int getNumUnackedMessages() {
        return UNICAST3.accumulate(Table::size, this.send_table.values());
    }

    @ManagedAttribute(description="Total number of undelivered messages in all receive windows", type=AttributeType.SCALAR)
    public int getXmitTableUndeliveredMessages() {
        return UNICAST3.accumulate(Table::size, this.recv_table.values());
    }

    @ManagedAttribute(description="Total number of missing messages in all receive windows", type=AttributeType.SCALAR)
    public int getXmitTableMissingMessages() {
        return UNICAST3.accumulate(Table::getNumMissing, this.recv_table.values());
    }

    @ManagedAttribute(description="Total number of deliverable messages in all receive windows", type=AttributeType.SCALAR)
    public int getXmitTableDeliverableMessages() {
        return UNICAST3.accumulate(Table::getNumDeliverable, this.recv_table.values());
    }

    @ManagedAttribute(description="Number of compactions in all (receive and send) windows")
    public int getXmitTableNumCompactions() {
        return UNICAST3.accumulate(Table::getNumCompactions, this.recv_table.values(), this.send_table.values());
    }

    @ManagedAttribute(description="Number of moves in all (receive and send) windows")
    public int getXmitTableNumMoves() {
        return UNICAST3.accumulate(Table::getNumMoves, this.recv_table.values(), this.send_table.values());
    }

    @ManagedAttribute(description="Number of resizes in all (receive and send) windows")
    public int getXmitTableNumResizes() {
        return UNICAST3.accumulate(Table::getNumResizes, this.recv_table.values(), this.send_table.values());
    }

    @ManagedAttribute(description="Number of purges in all (receive and send) windows")
    public int getXmitTableNumPurges() {
        return UNICAST3.accumulate(Table::getNumPurges, this.recv_table.values(), this.send_table.values());
    }

    @ManagedOperation(description="Prints the contents of the receive windows for all members")
    public String printReceiveWindowMessages() {
        StringBuilder ret = new StringBuilder(this.local_addr + ":\n");
        for (Map.Entry entry : this.recv_table.entrySet()) {
            Address addr = (Address)entry.getKey();
            Table buf = ((ReceiverEntry)entry.getValue()).msgs;
            ret.append(addr).append(": ").append(buf.toString()).append('\n');
        }
        return ret.toString();
    }

    @ManagedOperation(description="Prints the contents of the send windows for all members")
    public String printSendWindowMessages() {
        StringBuilder ret = new StringBuilder(this.local_addr + ":\n");
        for (Map.Entry entry : this.send_table.entrySet()) {
            Address addr = (Address)entry.getKey();
            Table buf = ((SenderEntry)entry.getValue()).msgs;
            ret.append(addr).append(": ").append(buf.toString()).append('\n');
        }
        return ret.toString();
    }

    @Override
    public void resetStats() {
        this.num_xmits = 0L;
        this.num_acks_received = 0L;
        this.num_acks_sent = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
        this.avg_delivery_batch_size.clear();
        Stream.of(this.xmit_reqs_received, this.xmit_reqs_sent, this.xmit_rsps_sent).forEach(LongAdder::reset);
        this.loopbed_back_msgs.reset();
    }

    @Override
    public void init() throws Exception {
        super.init();
        TP transport = this.getTransport();
        this.sends_can_block = transport instanceof TCP;
        this.time_service = transport.getTimeService();
        if (this.time_service == null) {
            throw new IllegalStateException("time service from transport is null");
        }
        this.last_sync_sent = new ExpiryCache(this.sync_min_interval);
        int estimated_max_msgs_in_xmit_req = (transport.getBundler().getMaxSize() - 50) * 8;
        int old_max_xmit_size = this.max_xmit_req_size;
        this.max_xmit_req_size = this.max_xmit_req_size <= 0 ? estimated_max_msgs_in_xmit_req : Math.min(this.max_xmit_req_size, estimated_max_msgs_in_xmit_req);
        if (old_max_xmit_size != this.max_xmit_req_size) {
            this.log.trace("%s: set max_xmit_req_size from %d to %d", this.local_addr, old_max_xmit_size, this.max_xmit_req_size);
        }
        if (this.xmit_interval <= 0L) {
            this.log.warn("%s: xmit_interval (%d) has to be > 0; setting it to the default of %d", this.local_addr, this.xmit_interval, 500L);
            this.xmit_interval = 500L;
        }
        if (!this.xmits_enabled) {
            Class<RED> cl;
            RejectedExecutionHandler handler = transport.getThreadPool().getRejectedExecutionHandler();
            if (handler != null && !UNICAST3.isCallerRunsHandler(handler)) {
                this.log.warn("%s: xmits_enabled == false requires a CallerRunsPolicy in the thread pool; replacing %s", this.local_addr, handler.getClass().getSimpleName());
                transport.getThreadPool().setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
            }
            if (this.stack.findProtocol((Class<? extends Protocol>)(cl = RED.class)) != null) {
                String e = String.format("found %s: when retransmission is disabled (xmits_enabled=false), this can lead to message loss. Please remove %s or enable retransmission", cl.getSimpleName(), cl.getSimpleName());
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void start() throws Exception {
        this.msg_cache.clear();
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (this.max_retransmit_time > 0L) {
            this.cache = new AgeOutCache(this.timer, this.max_retransmit_time, this);
        }
        this.running = true;
        this.startRetransmitTask();
    }

    @Override
    public void stop() {
        this.sendPendingAcks();
        this.running = false;
        this.stopRetransmitTask();
        this.xmit_task_map.clear();
        this.removeAllConnections();
        this.msg_cache.clear();
    }

    @Override
    public Object up(Message msg) {
        if (msg.getDest() == null || msg.isFlagSet(Message.Flag.NO_RELIABILITY)) {
            return this.up_prot.up(msg);
        }
        UnicastHeader3 hdr = (UnicastHeader3)msg.getHeader(this.id);
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        Address sender = msg.getSrc();
        switch (hdr.type) {
            case 0: {
                if (this.is_trace) {
                    this.log.trace("%s <-- %s: DATA(#%d, conn_id=%d%s)", this.local_addr, sender, hdr.seqno, hdr.conn_id, hdr.first ? ", first" : "");
                }
                if (Objects.equals(this.local_addr, sender)) {
                    this.handleDataReceivedFromSelf(sender, hdr.seqno, msg);
                    break;
                }
                this.handleDataReceived(sender, hdr.seqno, hdr.conn_id, hdr.first, msg);
                break;
            }
            default: {
                this.handleUpEvent(sender, msg, hdr);
            }
        }
        return null;
    }

    protected void handleUpEvent(Address sender, Message msg, UnicastHeader3 hdr) {
        try {
            switch (hdr.type) {
                case 0: {
                    throw new IllegalStateException("header of type DATA is not supposed to be handled by this method");
                }
                case 1: {
                    this.handleAckReceived(sender, hdr.seqno, hdr.conn_id, hdr.timestamp());
                    break;
                }
                case 2: {
                    this.handleResendingOfFirstMessage(sender, hdr.timestamp());
                    break;
                }
                case 3: {
                    this.handleXmitRequest(sender, (SeqnoList)msg.getObject());
                    break;
                }
                case 4: {
                    this.log.trace("%s <-- %s: CLOSE(conn-id=%s)", this.local_addr, sender, hdr.conn_id);
                    ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(sender);
                    if (entry != null && entry.connId() == hdr.conn_id) {
                        this.recv_table.remove(sender, entry);
                        this.log.trace("%s: removed receive connection for %s", this.local_addr, sender);
                    }
                    break;
                }
                default: {
                    this.log.error(Util.getMessage("TypeNotKnown"), this.local_addr, hdr.type);
                    break;
                }
            }
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("FailedHandlingEvent"), this.local_addr, t);
        }
    }

    @Override
    public void up(MessageBatch batch) {
        if (batch.dest() == null) {
            this.up_prot.up(batch);
            return;
        }
        Address sender = batch.sender();
        if (this.local_addr == null || this.local_addr.equals(sender)) {
            Entry entry;
            Entry entry2 = entry = this.local_addr != null ? (Entry)this.send_table.get(this.local_addr) : null;
            if (entry != null) {
                this.handleBatchFromSelf(batch, entry);
            }
            return;
        }
        int size = batch.size();
        LinkedHashMap<Short, List> msgs = new LinkedHashMap<Short, List>();
        ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(sender);
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            UnicastHeader3 hdr;
            Message msg = it.next();
            if (msg == null || msg.isFlagSet(Message.Flag.NO_RELIABILITY) || (hdr = (UnicastHeader3)msg.getHeader(this.id)) == null) continue;
            it.remove();
            if (hdr.type != 0) {
                this.handleUpEvent(msg.getSrc(), msg, hdr);
                continue;
            }
            List list = msgs.computeIfAbsent(hdr.conn_id, k -> new ArrayList(size));
            list.add(new LongTuple<Message>(hdr.seqno(), msg));
            if (hdr.first) {
                entry = this.getReceiverEntry(sender, hdr.seqno(), hdr.first, hdr.connId());
                continue;
            }
            if (entry != null) continue;
            this.msg_cache.cache(sender, msg);
            this.log.trace("%s: cached %s#%d", this.local_addr, sender, hdr.seqno());
        }
        if (!msgs.isEmpty()) {
            if (entry == null) {
                this.sendRequestForFirstSeqno(sender);
            } else {
                List list;
                List<Message> queued_msgs;
                if (!this.msg_cache.isEmpty() && (queued_msgs = this.msg_cache.drain(sender)) != null) {
                    this.addQueuedMessages(sender, entry, queued_msgs);
                }
                if (msgs.keySet().retainAll(Collections.singletonList(entry.connId()))) {
                    this.sendRequestForFirstSeqno(sender);
                }
                if ((list = (List)msgs.get(entry.connId())) != null && !list.isEmpty()) {
                    this.handleBatchReceived(entry, sender, list, batch.mode() == MessageBatch.Mode.OOB);
                }
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void handleBatchFromSelf(MessageBatch batch, Entry entry) {
        ArrayList<LongTuple<Message>> list = new ArrayList<LongTuple<Message>>(batch.size());
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            UnicastHeader3 hdr;
            Message msg = it.next();
            if (msg == null || msg.isFlagSet(Message.Flag.NO_RELIABILITY) || (hdr = (UnicastHeader3)msg.getHeader(this.id)) == null) continue;
            it.remove();
            if (hdr.type != 0) {
                this.handleUpEvent(msg.getSrc(), msg, hdr);
                continue;
            }
            if (entry.conn_id != hdr.conn_id) {
                it.remove();
                continue;
            }
            list.add(new LongTuple<Message>(hdr.seqno(), msg));
        }
        if (!list.isEmpty()) {
            if (this.is_trace) {
                this.log.trace("%s <-- %s: DATA(%s)", this.local_addr, batch.sender(), this.printMessageList(list));
            }
            int len = list.size();
            Table<Message> win = entry.msgs;
            this.update(entry, len);
            if (batch.mode() == MessageBatch.Mode.OOB) {
                MessageBatch oob_batch = new MessageBatch(this.local_addr, batch.sender(), batch.clusterName(), batch.multicast(), MessageBatch.Mode.OOB, len);
                for (LongTuple longTuple : list) {
                    long seq = longTuple.getVal1();
                    Message msg = win.get(seq);
                    if (msg == null || !msg.isFlagSet(Message.Flag.OOB) || !msg.setFlagIfAbsent(Message.TransientFlag.OOB_DELIVERED)) continue;
                    oob_batch.add(msg);
                }
                this.deliverBatch(oob_batch);
            }
            this.removeAndDeliver(win, batch.sender());
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View view = (View)evt.getArg();
                List<Address> new_members = view.getMembers();
                HashSet non_members = new HashSet(this.send_table.keySet());
                non_members.addAll(this.recv_table.keySet());
                this.members = new_members;
                new_members.forEach(non_members::remove);
                if (this.cache != null) {
                    this.cache.removeAll(new_members);
                }
                if (!non_members.isEmpty()) {
                    this.log.trace("%s: closing connections of non members %s", this.local_addr, non_members);
                    non_members.forEach(this::closeConnection);
                }
                if (!new_members.isEmpty()) {
                    for (Address mbr : new_members) {
                        Entry e = (Entry)this.send_table.get(mbr);
                        if (e != null && e.state() == State.CLOSING) {
                            e.state(State.OPEN);
                        }
                        if ((e = (Entry)this.recv_table.get(mbr)) == null || e.state() != State.CLOSING) continue;
                        e.state(State.OPEN);
                    }
                }
                this.xmit_task_map.keySet().retainAll(new_members);
                this.last_sync_sent.removeExpiredElements();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        Address dst = msg.getDest();
        if (dst == null || msg.isFlagSet(Message.Flag.NO_RELIABILITY)) {
            return this.down_prot.down(msg);
        }
        if (!this.running) {
            this.log.trace("%s: discarded message as start() has not yet been called, message: %s", this.local_addr, msg);
            return null;
        }
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        if (this.loopback && Objects.equals(this.local_addr, dst)) {
            if (msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK)) {
                return null;
            }
            this.loopbed_back_msgs.increment();
            return this.up_prot.up(msg);
        }
        SenderEntry entry = this.getSenderEntry(dst);
        boolean dont_loopback_set = msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK) && dst.equals(this.local_addr);
        short send_conn_id = entry.connId();
        long seqno = entry.sent_msgs_seqno.getAndIncrement();
        long sleep = 10L;
        if (msg instanceof Refcountable && !dont_loopback_set) {
            ((Refcountable)((Object)msg)).incr();
        }
        while (true) {
            try {
                msg.putHeader(this.id, UnicastHeader3.createDataHeader(seqno, send_conn_id, seqno == 1L));
                entry.msgs.add(seqno, msg, dont_loopback_set ? dont_loopback_filter : null);
                if (this.conn_expiry_timeout > 0L) {
                    entry.update();
                }
                if (!dont_loopback_set) break;
                entry.msgs.purge(entry.msgs.getHighestDeliverable());
            }
            catch (Throwable t) {
                if (!this.running) continue;
                Util.sleep(sleep);
                sleep = Math.min(5000L, sleep * 2L);
                if (this.running) continue;
            }
            break;
        }
        if (this.is_trace) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.local_addr).append(" --> ").append(dst).append(": DATA(").append("#").append(seqno).append(", conn_id=").append(send_conn_id);
            if (seqno == 1L) {
                sb.append(", first");
            }
            sb.append(')');
            this.log.trace(sb);
        }
        ++this.num_msgs_sent;
        return this.down_prot.down(msg);
    }

    public void closeConnection(Address mbr) {
        this.closeSendConnection(mbr);
        this.closeReceiveConnection(mbr);
    }

    public void closeSendConnection(Address mbr) {
        SenderEntry entry = (SenderEntry)this.send_table.get(mbr);
        if (entry != null) {
            entry.state(State.CLOSING);
        }
    }

    public void closeReceiveConnection(Address mbr) {
        ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(mbr);
        if (entry != null) {
            entry.state(State.CLOSING);
        }
    }

    protected void removeSendConnection(Address mbr) {
        SenderEntry entry = (SenderEntry)this.send_table.remove(mbr);
        if (entry != null) {
            entry.state(State.CLOSED);
            if (this.members.contains(mbr)) {
                this.sendClose(mbr, entry.connId());
            }
        }
    }

    protected void removeReceiveConnection(Address mbr) {
        this.sendPendingAcks();
        ReceiverEntry entry = (ReceiverEntry)this.recv_table.remove(mbr);
        if (entry != null) {
            entry.state(State.CLOSED);
        }
    }

    @ManagedOperation(description="Trashes all connections to other nodes. This is only used for testing")
    public void removeAllConnections() {
        this.send_table.clear();
        this.recv_table.clear();
    }

    protected void retransmit(SeqnoList missing, Address sender) {
        Message xmit_msg = new ObjectMessage(sender, missing).setFlag(Message.Flag.OOB).putHeader(this.id, UnicastHeader3.createXmitReqHeader());
        if (this.is_trace) {
            this.log.trace("%s --> %s: XMIT_REQ(%s)", this.local_addr, sender, missing);
        }
        this.down_prot.down(xmit_msg);
        this.xmit_reqs_sent.add(missing.size());
    }

    protected void retransmit(Message msg) {
        if (this.is_trace) {
            UnicastHeader3 hdr = (UnicastHeader3)msg.getHeader(this.id);
            long seqno = hdr != null ? hdr.seqno : -1L;
            this.log.trace("%s --> %s: resending(#%d)", this.local_addr, msg.getDest(), seqno);
        }
        this.resend(msg);
        ++this.num_xmits;
    }

    @Override
    public void expired(Address key) {
        if (key != null) {
            this.log.debug("%s: removing expired connection to %s", this.local_addr, key);
            this.closeConnection(key);
        }
    }

    protected void handleDataReceived(Address sender, long seqno, short conn_id, boolean first, Message msg) {
        List<Message> queued_msgs;
        ReceiverEntry entry = this.getReceiverEntry(sender, seqno, first, conn_id);
        if (entry == null) {
            this.msg_cache.cache(sender, msg);
            this.log.trace("%s: cached %s#%d", this.local_addr, sender, seqno);
            return;
        }
        if (!this.msg_cache.isEmpty() && (queued_msgs = this.msg_cache.drain(sender)) != null) {
            this.addQueuedMessages(sender, entry, queued_msgs);
        }
        this.addMessage(entry, sender, seqno, msg);
        this.removeAndDeliver(entry.msgs, sender);
    }

    protected void addMessage(ReceiverEntry entry, Address sender, long seqno, Message msg) {
        Table win = entry.msgs;
        this.update(entry, 1);
        boolean oob = msg.isFlagSet(Message.Flag.OOB);
        boolean added = win.add(seqno, oob ? DUMMY_OOB_MSG : msg);
        if (this.ack_threshold <= 1) {
            this.sendAck(sender, win.getHighestDeliverable(), entry.connId());
        } else {
            entry.sendAck();
        }
        if (oob && added) {
            this.deliverMessage(msg, sender, seqno);
        }
    }

    protected void addQueuedMessages(Address sender, ReceiverEntry entry, List<Message> queued_msgs) {
        for (Message msg : queued_msgs) {
            UnicastHeader3 hdr = (UnicastHeader3)msg.getHeader(this.id);
            if (hdr.conn_id != entry.conn_id) {
                this.log.warn("%s: dropped queued message %s#%d as its conn_id (%d) did not match (entry.conn_id=%d)", this.local_addr, sender, hdr.seqno, hdr.conn_id, entry.conn_id);
                continue;
            }
            this.addMessage(entry, sender, hdr.seqno(), msg);
        }
    }

    protected void handleDataReceivedFromSelf(Address sender, long seqno, Message msg) {
        Entry entry = (Entry)this.send_table.get(sender);
        if (entry == null || entry.state() == State.CLOSED) {
            this.log.warn("%s: entry not found for %s; dropping message", this.local_addr, sender);
            return;
        }
        this.update(entry, 1);
        Table<Message> win = entry.msgs;
        if (msg.isFlagSet(Message.Flag.OOB) && (msg = win.get(seqno)) != null && msg.isFlagSet(Message.Flag.OOB) && msg.setFlagIfAbsent(Message.TransientFlag.OOB_DELIVERED)) {
            this.deliverMessage(msg, sender, seqno);
        }
        this.removeAndDeliver(win, sender);
    }

    protected void handleBatchReceived(ReceiverEntry entry, Address sender, List<LongTuple<Message>> msgs, boolean oob) {
        if (this.is_trace) {
            this.log.trace("%s <-- %s: DATA(%s)", this.local_addr, sender, this.printMessageList(msgs));
        }
        int batch_size = msgs.size();
        Table win = entry.msgs;
        boolean added = win.add(msgs, oob, oob ? DUMMY_OOB_MSG : null);
        this.update(entry, batch_size);
        if (batch_size >= this.ack_threshold) {
            this.sendAck(sender, win.getHighestDeliverable(), entry.connId());
        } else {
            entry.sendAck();
        }
        if (added && oob) {
            MessageBatch oob_batch = new MessageBatch(this.local_addr, sender, null, false, MessageBatch.Mode.OOB, msgs.size());
            for (LongTuple<Message> tuple : msgs) {
                oob_batch.add(tuple.getVal2());
            }
            this.deliverBatch(oob_batch);
        }
        this.removeAndDeliver(win, sender);
    }

    protected void removeAndDeliver(Table<Message> win, Address sender) {
        AtomicInteger adders = win.getAdders();
        if (adders.getAndIncrement() != 0) {
            return;
        }
        MessageBatch batch = new MessageBatch(win.getNumDeliverable()).dest(this.local_addr).sender(sender).multicast(false);
        Supplier<MessageBatch> batch_creator = () -> batch;
        do {
            try {
                batch.reset();
                win.removeMany(true, this.max_batch_size, this.drop_oob_and_dont_loopback_msgs_filter, batch_creator, BATCH_ACCUMULATOR);
            }
            catch (Throwable t) {
                this.log.error("%s: failed removing messages from table for %s: %s", this.local_addr, sender, t);
            }
            if (batch.isEmpty()) continue;
            this.deliverBatch(batch);
        } while (adders.decrementAndGet() != 0);
    }

    protected String printMessageList(List<LongTuple<Message>> list) {
        UnicastHeader3 hdr;
        Message second;
        StringBuilder sb = new StringBuilder();
        int size = list.size();
        Message first = size > 0 ? list.get(0).getVal2() : null;
        Message message = second = size > 1 ? list.get(size - 1).getVal2() : first;
        if (first != null && (hdr = (UnicastHeader3)first.getHeader(this.id)) != null) {
            sb.append("#" + hdr.seqno);
        }
        if (second != null && (hdr = (UnicastHeader3)second.getHeader(this.id)) != null) {
            sb.append(" - #" + hdr.seqno);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReceiverEntry getReceiverEntry(Address sender, long seqno, boolean first, short conn_id) {
        ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(sender);
        if (entry != null && entry.connId() == conn_id) {
            return entry;
        }
        this.recv_table_lock.lock();
        try {
            entry = (ReceiverEntry)this.recv_table.get(sender);
            if (first) {
                if (entry == null) {
                    entry = this.createReceiverEntry(sender, seqno, conn_id);
                } else if (conn_id != entry.connId()) {
                    this.log.trace("%s: conn_id=%d != %d; resetting receiver window", this.local_addr, conn_id, entry.connId());
                    this.recv_table.remove(sender);
                    entry = this.createReceiverEntry(sender, seqno, conn_id);
                }
            } else if (entry == null || entry.connId() != conn_id) {
                this.recv_table_lock.unlock();
                this.sendRequestForFirstSeqno(sender);
                ReceiverEntry receiverEntry = null;
                return receiverEntry;
            }
            ReceiverEntry receiverEntry = entry;
            return receiverEntry;
        }
        finally {
            if (this.recv_table_lock.isHeldByCurrentThread()) {
                this.recv_table_lock.unlock();
            }
        }
    }

    protected SenderEntry getSenderEntry(Address dst) {
        SenderEntry entry = (SenderEntry)this.send_table.get(dst);
        if (entry == null || entry.state() == State.CLOSED) {
            if (entry != null) {
                this.send_table.remove(dst, entry);
            }
            entry = this.send_table.computeIfAbsent(dst, k -> new SenderEntry(this.getNewConnectionId()));
            this.log.trace("%s: created sender window for %s (conn-id=%s)", this.local_addr, dst, entry.connId());
            if (this.cache != null && !this.members.contains(dst)) {
                this.cache.add(dst);
            }
        }
        if (entry.state() == State.CLOSING) {
            entry.state(State.OPEN);
        }
        return entry;
    }

    protected ReceiverEntry createReceiverEntry(Address sender, long seqno, short conn_id) {
        ReceiverEntry entry = this.recv_table.computeIfAbsent(sender, k -> new ReceiverEntry(this.createTable(seqno), conn_id));
        this.log.trace("%s: created receiver window for %s at seqno=#%d for conn-id=%d", this.local_addr, sender, seqno, conn_id);
        return entry;
    }

    protected Table<Message> createTable(long seqno) {
        return new Table<Message>(this.xmit_table_num_rows, this.xmit_table_msgs_per_row, seqno - 1L, this.xmit_table_resize_factor, this.xmit_table_max_compaction_time);
    }

    protected void handleAckReceived(Address sender, long seqno, short conn_id, int timestamp) {
        Table win;
        SenderEntry entry;
        if (this.is_trace) {
            this.log.trace("%s <-- %s: ACK(#%d, conn-id=%d, ts=%d)", this.local_addr, sender, seqno, conn_id, timestamp);
        }
        if ((entry = (SenderEntry)this.send_table.get(sender)) != null && entry.connId() != conn_id) {
            this.log.trace("%s: my conn_id (%d) != received conn_id (%d); discarding ACK", this.local_addr, entry.connId(), conn_id);
            return;
        }
        Table table = win = entry != null ? entry.msgs : null;
        if (win != null && entry.updateLastTimestamp(timestamp)) {
            win.forEach(win.getLow(), seqno, DECR);
            win.purge(seqno, true);
            ++this.num_acks_received;
        }
    }

    protected void handleResendingOfFirstMessage(Address sender, int timestamp) {
        Table win;
        this.log.trace("%s <-- %s: SEND_FIRST_SEQNO", this.local_addr, sender);
        SenderEntry entry = (SenderEntry)this.send_table.get(sender);
        Table table = win = entry != null ? entry.msgs : null;
        if (win == null) {
            this.log.warn(Util.getMessage("SenderNotFound"), this.local_addr, sender);
            return;
        }
        if (!entry.updateLastTimestamp(timestamp)) {
            return;
        }
        Message rsp = (Message)win.get(win.getLow() + 1L);
        if (rsp != null) {
            Message copy = rsp.copy(true, true);
            UnicastHeader3 hdr = (UnicastHeader3)copy.getHeader(this.id);
            UnicastHeader3 newhdr = hdr.copy();
            newhdr.first = true;
            copy.putHeader(this.id, newhdr);
            this.resend(copy);
        }
    }

    protected void handleXmitRequest(Address sender, SeqnoList missing) {
        Table win;
        if (this.is_trace) {
            this.log.trace("%s <-- %s: XMIT(#%s)", this.local_addr, sender, missing);
        }
        SenderEntry entry = (SenderEntry)this.send_table.get(sender);
        this.xmit_reqs_received.add(missing.size());
        Table table = win = entry != null ? entry.msgs : null;
        if (win == null) {
            return;
        }
        for (Long seqno : missing) {
            Message msg = (Message)win.get(seqno);
            if (msg == null) {
                if (!this.log.isWarnEnabled() || !this.log_not_found_msgs || this.local_addr.equals(sender) || seqno <= win.getLow()) continue;
                this.log.warn(Util.getMessage("MessageNotFound"), this.local_addr, sender, seqno);
                continue;
            }
            this.resend(msg);
            this.xmit_rsps_sent.increment();
        }
    }

    protected void resend(Message msg) {
        this.down_prot.down(msg);
    }

    protected void deliverMessage(Message msg, Address sender, long seqno) {
        if (this.is_trace) {
            this.log.trace("%s: delivering %s#%s", this.local_addr, sender, seqno);
        }
        try {
            this.up_prot.up(msg);
        }
        catch (Throwable t) {
            this.log.warn(Util.getMessage("FailedToDeliverMsg"), this.local_addr, msg.isFlagSet(Message.Flag.OOB) ? "OOB message" : "message", msg, t);
        }
    }

    protected void deliverBatch(MessageBatch batch) {
        try {
            if (batch.isEmpty()) {
                return;
            }
            if (this.is_trace) {
                Object first = batch.first();
                Object last = batch.last();
                StringBuilder sb = new StringBuilder(this.local_addr + ": delivering");
                if (first != null && last != null) {
                    UnicastHeader3 hdr1 = (UnicastHeader3)first.getHeader(this.id);
                    UnicastHeader3 hdr2 = (UnicastHeader3)last.getHeader(this.id);
                    if (hdr1 != null && hdr2 != null) {
                        sb.append(" #").append(hdr1.seqno).append(" - #").append(hdr2.seqno);
                    }
                }
                sb.append(" (" + batch.size()).append(" messages)");
                this.log.trace(sb);
            }
            if (this.stats) {
                this.avg_delivery_batch_size.add(batch.size());
            }
            this.up_prot.up(batch);
        }
        catch (Throwable t) {
            this.log.warn(Util.getMessage("FailedToDeliverMsg"), this.local_addr, "batch", batch, t);
        }
    }

    protected long getTimestamp() {
        return this.time_service.timestamp();
    }

    public void startRetransmitTask() {
        if (this.xmit_task == null || this.xmit_task.isDone()) {
            this.xmit_task = this.timer.scheduleWithFixedDelay(new RetransmitTask(), 0L, this.xmit_interval, TimeUnit.MILLISECONDS, this.sends_can_block);
        }
    }

    public void stopRetransmitTask() {
        if (this.xmit_task != null) {
            this.xmit_task.cancel(true);
            this.xmit_task = null;
        }
    }

    protected static boolean isCallerRunsHandler(RejectedExecutionHandler h) {
        return h instanceof ThreadPoolExecutor.CallerRunsPolicy || h instanceof ShutdownRejectedExecutionHandler && ((ShutdownRejectedExecutionHandler)h).handler() instanceof ThreadPoolExecutor.CallerRunsPolicy;
    }

    protected void sendAck(Address dst, long seqno, short conn_id) {
        if (!this.running) {
            return;
        }
        Message ack = new EmptyMessage(dst).putHeader(this.id, UnicastHeader3.createAckHeader(seqno, conn_id, this.timestamper.incrementAndGet()));
        if (this.is_trace) {
            this.log.trace("%s --> %s: ACK(#%d)", this.local_addr, dst, seqno);
        }
        try {
            this.down_prot.down(ack);
            ++this.num_acks_sent;
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("FailedSendingAck"), this.local_addr, seqno, dst, t);
        }
    }

    protected synchronized short getNewConnectionId() {
        short retval = this.last_conn_id;
        this.last_conn_id = this.last_conn_id == Short.MAX_VALUE || this.last_conn_id < 0 ? (short)0 : (short)(this.last_conn_id + 1);
        return retval;
    }

    protected void sendRequestForFirstSeqno(Address dest) {
        if (this.last_sync_sent.addIfAbsentOrExpired(dest)) {
            Message msg = new EmptyMessage(dest).setFlag(Message.Flag.OOB).putHeader(this.id, UnicastHeader3.createSendFirstSeqnoHeader(this.timestamper.incrementAndGet()));
            this.log.trace("%s --> %s: SEND_FIRST_SEQNO", this.local_addr, dest);
            this.down_prot.down(msg);
        }
    }

    public void sendClose(Address dest, short conn_id) {
        Message msg = new EmptyMessage(dest).putHeader(this.id, UnicastHeader3.createCloseHeader(conn_id));
        this.log.trace("%s --> %s: CLOSE(conn-id=%d)", this.local_addr, dest, conn_id);
        this.down_prot.down(msg);
    }

    @ManagedOperation(description="Closes connections that have been idle for more than conn_expiry_timeout ms")
    public void closeIdleConnections() {
        long age;
        Entry val;
        for (Map.Entry entry : this.send_table.entrySet()) {
            val = (SenderEntry)entry.getValue();
            if (val.state() != State.OPEN || (age = val.age()) < this.conn_expiry_timeout) continue;
            this.log.debug("%s: closing expired connection for %s (%d ms old) in send_table", this.local_addr, entry.getKey(), age);
            this.closeSendConnection((Address)entry.getKey());
        }
        for (Map.Entry entry : this.recv_table.entrySet()) {
            val = (ReceiverEntry)entry.getValue();
            if (val.state() != State.OPEN || (age = val.age()) < this.conn_expiry_timeout) continue;
            this.log.debug("%s: closing expired connection for %s (%d ms old) in recv_table", this.local_addr, entry.getKey(), age);
            this.closeReceiveConnection((Address)entry.getKey());
        }
    }

    @ManagedOperation(description="Removes connections that have been closed for more than conn_close_timeout ms")
    public int removeExpiredConnections() {
        long age;
        Entry val;
        int num_removed = 0;
        for (Map.Entry entry : this.send_table.entrySet()) {
            val = (SenderEntry)entry.getValue();
            if (val.state() == State.OPEN || (age = val.age()) < this.conn_close_timeout) continue;
            this.log.debug("%s: removing expired connection for %s (%d ms old) from send_table", this.local_addr, entry.getKey(), age);
            this.removeSendConnection((Address)entry.getKey());
            ++num_removed;
        }
        for (Map.Entry entry : this.recv_table.entrySet()) {
            val = (ReceiverEntry)entry.getValue();
            if (val.state() == State.OPEN || (age = val.age()) < this.conn_close_timeout) continue;
            this.log.debug("%s: removing expired connection for %s (%d ms old) from recv_table", this.local_addr, entry.getKey(), age);
            this.removeReceiveConnection((Address)entry.getKey());
            ++num_removed;
        }
        return num_removed;
    }

    @ManagedOperation(description="Removes send- and/or receive-connections whose state is not OPEN (CLOSING or CLOSED)")
    public int removeConnections(boolean remove_send_connections, boolean remove_receive_connections) {
        Entry val;
        int num_removed = 0;
        if (remove_send_connections) {
            for (Map.Entry entry : this.send_table.entrySet()) {
                val = (SenderEntry)entry.getValue();
                if (val.state() == State.OPEN) continue;
                this.log.debug("%s: removing connection for %s (%d ms old, state=%s) from send_table", new Object[]{this.local_addr, entry.getKey(), val.age(), val.state()});
                this.removeSendConnection((Address)entry.getKey());
                ++num_removed;
            }
        }
        if (remove_receive_connections) {
            for (Map.Entry entry : this.recv_table.entrySet()) {
                val = (ReceiverEntry)entry.getValue();
                if (val.state() == State.OPEN) continue;
                this.log.debug("%s: removing expired connection for %s (%d ms old, state=%s) from recv_table", new Object[]{this.local_addr, entry.getKey(), val.age(), val.state()});
                this.removeReceiveConnection((Address)entry.getKey());
                ++num_removed;
            }
        }
        return num_removed;
    }

    @ManagedOperation(description="Triggers the retransmission task")
    public void triggerXmit() {
        for (Map.Entry entry : this.recv_table.entrySet()) {
            SeqnoList missing;
            Table win;
            Address target = (Address)entry.getKey();
            ReceiverEntry val = (ReceiverEntry)entry.getValue();
            Table table = win = val != null ? val.msgs : null;
            if (win != null && val.needToSendAck()) {
                this.sendAck(target, win.getHighestDeliverable(), val.connId());
            }
            if (!this.xmits_enabled) continue;
            if (win != null && win.getNumMissing() > 0 && (missing = win.getMissing(this.max_xmit_req_size)) != null) {
                long highest = missing.getLast();
                Long prev_seqno = this.xmit_task_map.get(target);
                if (prev_seqno == null) {
                    this.xmit_task_map.put(target, highest);
                    continue;
                }
                missing.removeHigherThan(prev_seqno);
                if (highest > prev_seqno) {
                    this.xmit_task_map.put(target, highest);
                }
                if (missing.isEmpty()) continue;
                long highest_deliverable = win.getHighestDeliverable();
                long first = missing.getFirst();
                if (first < highest_deliverable) {
                    missing.removeLowerThan(highest_deliverable + 1L);
                }
                this.retransmit(missing, target);
                continue;
            }
            if (this.xmit_task_map.isEmpty()) continue;
            this.xmit_task_map.remove(target);
        }
        if (this.xmits_enabled) {
            for (SenderEntry val : this.send_table.values()) {
                long highest_sent;
                Table win = val != null ? val.msgs : null;
                if (win == null) continue;
                long highest_acked = win.getHighestDelivered();
                if (highest_acked < (highest_sent = win.getHighestReceived()) && val.watermark[0] == highest_acked && val.watermark[1] == highest_sent) {
                    Message highest_sent_msg = (Message)win.get(highest_sent);
                    if (highest_sent_msg == null) continue;
                    this.retransmit(highest_sent_msg);
                    continue;
                }
                val.watermark(highest_acked, highest_sent);
            }
        }
        if (this.conn_expiry_timeout > 0L) {
            this.closeIdleConnections();
        }
        if (this.conn_close_timeout > 0L) {
            this.removeExpiredConnections();
        }
    }

    @ManagedOperation(description="Sends ACKs immediately for entries which are marked as pending (ACK hasn't been sent yet)")
    public void sendPendingAcks() {
        for (Map.Entry entry : this.recv_table.entrySet()) {
            Address target = (Address)entry.getKey();
            ReceiverEntry val = (ReceiverEntry)entry.getValue();
            Table win = val != null ? val.msgs : null;
            if (win == null || !val.needToSendAck()) continue;
            this.sendAck(target, win.getHighestDeliverable(), val.connId());
        }
    }

    protected void update(Entry entry, int num_received) {
        if (this.conn_expiry_timeout > 0L) {
            entry.update();
        }
        if (entry.state() == State.CLOSING) {
            entry.state(State.OPEN);
        }
        this.num_msgs_received += (long)num_received;
    }

    protected static int compare(int ts1, int ts2) {
        int diff = ts1 - ts2;
        return Integer.compare(diff, 0);
    }

    @SafeVarargs
    protected static int accumulate(ToIntFunction<Table<Message>> func, Collection<? extends Entry> ... entries) {
        return Stream.of(entries).flatMap(Collection::stream).map(entry -> entry.msgs).filter(Objects::nonNull).mapToInt(func).sum();
    }

    protected class MessageCache {
        private final Map<Address, List<Message>> map = new ConcurrentHashMap<Address, List<Message>>();
        private volatile boolean is_empty = true;

        protected MessageCache() {
        }

        protected MessageCache cache(Address sender, Message msg) {
            List list = this.map.computeIfAbsent(sender, addr -> new ArrayList());
            list.add(msg);
            this.is_empty = false;
            return this;
        }

        protected List<Message> drain(Address sender) {
            List<Message> list = this.map.remove(sender);
            if (this.map.isEmpty()) {
                this.is_empty = true;
            }
            return list;
        }

        protected MessageCache clear() {
            this.map.clear();
            this.is_empty = true;
            return this;
        }

        protected int size() {
            return this.map.values().stream().mapToInt(Collection::size).sum();
        }

        protected boolean isEmpty() {
            return this.is_empty;
        }

        public String toString() {
            return String.format("%d message(s)", this.size());
        }
    }

    protected class RetransmitTask
    implements Runnable {
        protected RetransmitTask() {
        }

        @Override
        public void run() {
            UNICAST3.this.triggerXmit();
        }

        public String toString() {
            return UNICAST3.class.getSimpleName() + ": RetransmitTask (interval=" + UNICAST3.this.xmit_interval + " ms)";
        }
    }

    protected final class ReceiverEntry
    extends Entry {
        private final AtomicBoolean send_ack;

        public ReceiverEntry(Table<Message> received_msgs, short recv_conn_id) {
            super(recv_conn_id, received_msgs);
            this.send_ack = new AtomicBoolean();
        }

        ReceiverEntry sendAck() {
            this.send_ack.compareAndSet(false, true);
            return this;
        }

        boolean needToSendAck() {
            return this.send_ack.compareAndSet(true, false);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.msgs != null) {
                sb.append(this.msgs).append(", ");
            }
            sb.append("recv_conn_id=" + this.conn_id).append(" (" + this.age() / 1000L + " secs old) - " + this.state);
            if (this.send_ack.get()) {
                sb.append(" [ack pending]");
            }
            return sb.toString();
        }
    }

    protected final class SenderEntry
    extends Entry {
        final AtomicLong sent_msgs_seqno;
        final long[] watermark;
        int last_timestamp;

        public SenderEntry(short send_conn_id) {
            super(send_conn_id, new Table<Message>(UNICAST3.this.xmit_table_num_rows, UNICAST3.this.xmit_table_msgs_per_row, 0L, UNICAST3.this.xmit_table_resize_factor, UNICAST3.this.xmit_table_max_compaction_time));
            this.sent_msgs_seqno = new AtomicLong(1L);
            this.watermark = new long[]{0L, 0L};
        }

        long[] watermark() {
            return this.watermark;
        }

        SenderEntry watermark(long ha, long hs) {
            this.watermark[0] = ha;
            this.watermark[1] = hs;
            return this;
        }

        private synchronized boolean updateLastTimestamp(int ts) {
            boolean success;
            if (this.last_timestamp == 0) {
                this.last_timestamp = ts;
                return true;
            }
            boolean bl = success = UNICAST3.compare(ts, this.last_timestamp) > 0;
            if (success) {
                this.last_timestamp = ts;
            }
            return success;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.msgs != null) {
                sb.append(this.msgs).append(", ");
            }
            sb.append("send_conn_id=" + this.conn_id).append(" (" + this.age() / 1000L + " secs old) - " + this.state);
            if (this.last_timestamp != 0) {
                sb.append(", last-ts: ").append(this.last_timestamp);
            }
            return sb.toString();
        }
    }

    protected abstract class Entry {
        protected final Table<Message> msgs;
        protected final short conn_id;
        protected final AtomicLong timestamp = new AtomicLong(0L);
        protected volatile State state = State.OPEN;

        protected Entry(short conn_id, Table<Message> msgs) {
            this.conn_id = conn_id;
            this.msgs = msgs;
            this.update();
        }

        short connId() {
            return this.conn_id;
        }

        void update() {
            this.timestamp.set(UNICAST3.this.getTimestamp());
        }

        State state() {
            return this.state;
        }

        Entry state(State state) {
            if (this.state != state) {
                this.state = state;
                this.update();
            }
            return this;
        }

        long age() {
            return TimeUnit.MILLISECONDS.convert(UNICAST3.this.getTimestamp() - this.timestamp.longValue(), TimeUnit.NANOSECONDS);
        }
    }

    protected static enum State {
        OPEN,
        CLOSING,
        CLOSED;

    }
}

