/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.Set;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.massindexing.impl.ConditionalExpression;

public class HibernateOrmQueryLoader<E, I> {
    private final TypeQueryFactory<E, I> queryFactory;
    private final Set<Class<? extends E>> includedTypesFilter;
    private final EntityMappingType entityMappingType;
    private final ConditionalExpression conditionalExpression;

    public HibernateOrmQueryLoader(TypeQueryFactory<E, I> queryFactory, Set<Class<? extends E>> includedTypesFilter) {
        this.queryFactory = queryFactory;
        this.includedTypesFilter = includedTypesFilter;
        this.entityMappingType = null;
        this.conditionalExpression = null;
    }

    public HibernateOrmQueryLoader(TypeQueryFactory<E, I> queryFactory, EntityMappingType entityMappingType, Set<Class<? extends E>> includedTypesFilter, ConditionalExpression conditionalExpression) {
        this.queryFactory = queryFactory;
        this.includedTypesFilter = includedTypesFilter;
        this.entityMappingType = entityMappingType;
        this.conditionalExpression = conditionalExpression;
    }

    public Query<Long> createCountQuery(SharedSessionContractImplementor session) {
        return this.conditionalExpression == null ? this.queryFactory.createQueryForCount(session, this.includedTypesFilter) : this.queryFactory.createQueryForCount(session, this.entityMappingType, this.includedTypesFilter, this.conditionalExpression);
    }

    public Query<I> createIdentifiersQuery(SharedSessionContractImplementor session) {
        return this.conditionalExpression == null ? this.queryFactory.createQueryForIdentifierListing(session, this.includedTypesFilter) : this.queryFactory.createQueryForIdentifierListing(session, this.entityMappingType, this.includedTypesFilter, this.conditionalExpression);
    }

    public Query<E> createLoadingQuery(SessionImplementor session, String idParameterName) {
        return this.queryFactory.createQueryForLoadByUniqueProperty(session, idParameterName);
    }

    public MultiIdentifierLoadAccess<E> createMultiIdentifierLoadAccess(SessionImplementor session) {
        return this.queryFactory.createMultiIdentifierLoadAccess(session);
    }

    public boolean uniquePropertyIsTheEntityId() {
        return this.queryFactory.uniquePropertyIsTheEntityId();
    }
}

