/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.auth;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.internal.transport.sshd.auth.AbstractAuthenticationHandler;

public abstract class BasicAuthentication<ParameterType, TokenType>
extends AbstractAuthenticationHandler<ParameterType, TokenType> {
    protected String user;
    protected byte[] password;

    public BasicAuthentication(InetSocketAddress proxy, String initialUser, char[] initialPassword) {
        super(proxy);
        this.user = initialUser;
        this.password = this.convert(initialPassword);
    }

    private byte[] convert(char[] pass) {
        if (pass == null) {
            return new byte[0];
        }
        ByteBuffer bytes = StandardCharsets.UTF_8.encode(CharBuffer.wrap(pass));
        byte[] pwd = new byte[bytes.remaining()];
        bytes.get(pwd);
        if (bytes.hasArray()) {
            Arrays.fill(bytes.array(), (byte)0);
        }
        Arrays.fill(pass, '\u0000');
        return pwd;
    }

    protected void clearPassword() {
        if (this.password != null) {
            Arrays.fill(this.password, (byte)0);
        }
        this.password = new byte[0];
    }

    @Override
    public final void close() {
        this.clearPassword();
        this.done = true;
    }

    @Override
    public final void start() throws Exception {
        if (this.user != null && !this.user.isEmpty() || this.password != null && this.password.length > 0) {
            return;
        }
        this.askCredentials();
    }

    @Override
    public void process() throws Exception {
        this.askCredentials();
    }

    protected void askCredentials() {
        this.clearPassword();
        PasswordAuthentication auth = AccessController.doPrivileged(() -> Authenticator.requestPasswordAuthentication(this.proxy.getHostString(), this.proxy.getAddress(), this.proxy.getPort(), "ssh", SshdText.get().proxyPasswordPrompt, "Basic", null, Authenticator.RequestorType.PROXY));
        if (auth == null) {
            this.user = "";
            throw new CancellationException(SshdText.get().authenticationCanceled);
        }
        this.user = auth.getUserName();
        this.password = this.convert(auth.getPassword());
    }
}

