/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamSizeOperation;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValue;

public class ByteBufferMarshalledValueMarshaller
implements ProtoStreamMarshaller<ByteBufferMarshalledValue<Object>> {
    private static final int BUFFER_INDEX = 1;

    @Override
    public ByteBufferMarshalledValue<Object> readFrom(ProtoStreamReader reader) throws IOException {
        ByteBuffer buffer = null;
        block3: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    buffer = reader.readByteBuffer();
                    continue block3;
                }
            }
            reader.skipField(tag);
        }
        return new ByteBufferMarshalledValue(buffer);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, ByteBufferMarshalledValue<Object> key) throws IOException {
        ByteBuffer buffer = key.getBuffer();
        if (buffer != null) {
            writer.writeBytes(1, buffer);
        }
    }

    @Override
    public OptionalInt size(ProtoStreamSizeOperation operation, ByteBufferMarshalledValue<Object> value) {
        if (value.isEmpty()) {
            return OptionalInt.of(0);
        }
        OptionalInt size = value.size();
        return size.isPresent() ? OptionalInt.of(operation.tagSize(1, WireType.LENGTH_DELIMITED) + operation.varIntSize(size.getAsInt()) + size.getAsInt()) : OptionalInt.empty();
    }

    @Override
    public Class<? extends ByteBufferMarshalledValue<Object>> getJavaClass() {
        return ByteBufferMarshalledValue.class;
    }
}

