/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchTermsAggregation;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchExistsPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchPredicateTypeKeys;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchRangePredicate;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchFieldHighlightProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchFieldProjection;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchStringFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchSimpleQueryStringPredicateBuilderFieldState;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchTermsPredicate;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchTextMatchPredicate;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchTextPhrasePredicate;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchTextRegexpPredicate;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchTextWildcardPredicate;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSort;
import org.hibernate.search.engine.backend.types.Aggregable;
import org.hibernate.search.engine.backend.types.Highlightable;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.Norms;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.TermVector;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.search.aggregation.spi.AggregationTypeKeys;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;
import org.hibernate.search.engine.search.sort.spi.SortTypeKeys;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchStringIndexFieldTypeOptionsStep
extends AbstractElasticsearchStandardIndexFieldTypeOptionsStep<ElasticsearchStringIndexFieldTypeOptionsStep, String>
implements StringIndexFieldTypeOptionsStep<ElasticsearchStringIndexFieldTypeOptionsStep> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private String analyzerName;
    private String searchAnalyzerName;
    private String normalizerName;
    private Projectable projectable = Projectable.DEFAULT;
    private Searchable searchable = Searchable.DEFAULT;
    private Norms norms = Norms.DEFAULT;
    private Sortable sortable = Sortable.DEFAULT;
    private Aggregable aggregable = Aggregable.DEFAULT;
    private String indexNullAs;
    private TermVector termVector = TermVector.DEFAULT;
    private Set<Highlightable> highlightable;

    ElasticsearchStringIndexFieldTypeOptionsStep(ElasticsearchIndexFieldTypeBuildContext buildContext) {
        super(buildContext, String.class);
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep analyzer(String analyzerName) {
        this.analyzerName = analyzerName;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep searchAnalyzer(String searchAnalyzerName) {
        this.searchAnalyzerName = searchAnalyzerName;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep normalizer(String normalizerName) {
        this.normalizerName = normalizerName;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep projectable(Projectable projectable) {
        this.projectable = projectable;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep norms(Norms norms) {
        this.norms = norms;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep termVector(TermVector termVector) {
        this.termVector = termVector;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep highlightable(Collection<Highlightable> highlightable) {
        Contracts.assertNotNull(highlightable, (String)"highlightable");
        this.highlightable = highlightable.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(highlightable);
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep indexNullAs(String indexNullAs) {
        this.indexNullAs = indexNullAs;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep searchable(Searchable searchable) {
        this.searchable = searchable;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep aggregable(Aggregable aggregable) {
        this.aggregable = aggregable;
        return this;
    }

    public IndexFieldType<String> toIndexFieldType() {
        PropertyMapping mapping = this.builder.mapping();
        boolean resolvedSortable = ElasticsearchStringIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = ElasticsearchStringIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = ElasticsearchStringIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        boolean resolvedAggregable = ElasticsearchStringIndexFieldTypeOptionsStep.resolveDefault(this.aggregable);
        mapping.setIndex(resolvedSearchable);
        if (this.analyzerName != null) {
            mapping.setType("text");
            mapping.setAnalyzer(this.analyzerName);
            mapping.setSearchAnalyzer(this.searchAnalyzerName);
            mapping.setTermVector(this.resolveTermVector());
            this.builder.analyzerName(this.analyzerName);
            this.builder.searchAnalyzerName(this.searchAnalyzerName);
            Set<SearchHighlighterType> allowedHighlighterTypes = this.resolveAllowedHighlighterTypes();
            this.builder.allowedHighlighterTypes(allowedHighlighterTypes);
            if (!allowedHighlighterTypes.isEmpty()) {
                this.builder.queryElementFactory(ProjectionTypeKeys.HIGHLIGHT, new ElasticsearchFieldHighlightProjection.Factory());
            }
            if (this.normalizerName != null) {
                throw log.cannotApplyAnalyzerAndNormalizer(this.analyzerName, this.normalizerName, this.buildContext.getEventContext());
            }
            if (resolvedSortable) {
                throw log.cannotUseAnalyzerOnSortableField(this.analyzerName, this.buildContext.getEventContext());
            }
            if (this.indexNullAs != null) {
                throw log.cannotUseIndexNullAsAndAnalyzer(this.analyzerName, this.indexNullAs, this.buildContext.getEventContext());
            }
            if (resolvedAggregable) {
                throw log.cannotUseAnalyzerOnAggregableField(this.analyzerName, this.buildContext.getEventContext());
            }
        } else {
            mapping.setType("keyword");
            mapping.setNormalizer(this.normalizerName);
            mapping.setDocValues(resolvedSortable || resolvedAggregable);
            this.builder.normalizerName(this.normalizerName);
            if (this.searchAnalyzerName != null) {
                throw log.searchAnalyzerWithoutAnalyzer(this.searchAnalyzerName, this.buildContext.getEventContext());
            }
        }
        mapping.setNorms(this.resolveNorms());
        if (this.indexNullAs != null) {
            mapping.setNullValue((JsonElement)new JsonPrimitive(this.indexNullAs));
        }
        ElasticsearchStringFieldCodec codec = ElasticsearchStringFieldCodec.INSTANCE;
        this.builder.codec(codec);
        if (resolvedSearchable) {
            this.builder.searchable(true);
            this.builder.queryElementFactory(PredicateTypeKeys.MATCH, new ElasticsearchTextMatchPredicate.Factory(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.RANGE, new ElasticsearchRangePredicate.Factory<String>(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.EXISTS, new ElasticsearchExistsPredicate.Factory());
            this.builder.queryElementFactory(PredicateTypeKeys.PHRASE, new ElasticsearchTextPhrasePredicate.Factory());
            this.builder.queryElementFactory(PredicateTypeKeys.WILDCARD, new ElasticsearchTextWildcardPredicate.Factory());
            this.builder.queryElementFactory(PredicateTypeKeys.REGEXP, new ElasticsearchTextRegexpPredicate.Factory());
            this.builder.queryElementFactory(PredicateTypeKeys.TERMS, new ElasticsearchTermsPredicate.Factory<String>(codec));
            this.builder.queryElementFactory(ElasticsearchPredicateTypeKeys.SIMPLE_QUERY_STRING, new ElasticsearchSimpleQueryStringPredicateBuilderFieldState.Factory());
        }
        if (resolvedSortable) {
            this.builder.sortable(true);
            this.builder.queryElementFactory(SortTypeKeys.FIELD, new ElasticsearchStandardFieldSort.TextFieldFactory(codec));
        }
        if (resolvedProjectable) {
            this.builder.projectable(true);
            this.builder.queryElementFactory(ProjectionTypeKeys.FIELD, new ElasticsearchFieldProjection.Factory<String>(codec));
        }
        if (resolvedAggregable) {
            this.builder.aggregable(true);
            this.builder.queryElementFactory(AggregationTypeKeys.TERMS, new ElasticsearchTermsAggregation.Factory<String>(codec));
        }
        return this.builder.build();
    }

    @Override
    protected ElasticsearchStringIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }

    private boolean resolveNorms() {
        switch (this.norms) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
            case DEFAULT: {
                return this.analyzerName != null;
            }
        }
        throw new AssertionFailure("Unexpected value for Norms: " + this.norms);
    }

    private String resolveTermVector() {
        if (this.highlightable != null && (this.highlightable.contains(Highlightable.FAST_VECTOR) || this.highlightable.contains(Highlightable.ANY))) {
            if (TermVector.DEFAULT.equals((Object)this.termVector)) {
                return TermVector.WITH_POSITIONS_OFFSETS.name().toLowerCase(Locale.ROOT);
            }
            if (TermVector.WITH_POSITIONS_OFFSETS.equals((Object)this.termVector) || TermVector.WITH_POSITIONS_OFFSETS_PAYLOADS.equals((Object)this.termVector)) {
                return this.termVector.name().toLowerCase(Locale.ROOT);
            }
            throw log.termVectorDontAllowFastVectorHighlighter(this.termVector);
        }
        switch (this.termVector) {
            case NO: 
            case DEFAULT: {
                return "no";
            }
        }
        return this.termVector.name().toLowerCase(Locale.ROOT);
    }

    private Set<SearchHighlighterType> resolveAllowedHighlighterTypes() {
        if (this.highlightable == null) {
            this.highlightable = EnumSet.of(Highlightable.DEFAULT);
        }
        if (this.highlightable.isEmpty()) {
            throw log.noHighlightableProvided();
        }
        if (this.highlightable.contains(Highlightable.DEFAULT)) {
            this.highlightable = TermVector.WITH_POSITIONS_OFFSETS.equals((Object)this.termVector) || TermVector.WITH_POSITIONS_OFFSETS_PAYLOADS.equals((Object)this.termVector) ? EnumSet.of(Highlightable.ANY) : EnumSet.of(Highlightable.UNIFIED, Highlightable.PLAIN);
        }
        if (this.highlightable.contains(Highlightable.NO)) {
            if (this.highlightable.size() == 1) {
                return Collections.emptySet();
            }
            throw log.unsupportedMixOfHighlightableValues(this.highlightable);
        }
        if (this.highlightable.contains(Highlightable.ANY)) {
            return EnumSet.of(SearchHighlighterType.PLAIN, SearchHighlighterType.UNIFIED, SearchHighlighterType.FAST_VECTOR);
        }
        HashSet<SearchHighlighterType> highlighters = new HashSet<SearchHighlighterType>();
        if (this.highlightable.contains(Highlightable.PLAIN)) {
            highlighters.add(SearchHighlighterType.PLAIN);
        }
        if (this.highlightable.contains(Highlightable.UNIFIED)) {
            highlighters.add(SearchHighlighterType.UNIFIED);
        }
        if (this.highlightable.contains(Highlightable.FAST_VECTOR)) {
            highlighters.add(SearchHighlighterType.FAST_VECTOR);
        }
        return EnumSet.copyOf(highlighters);
    }
}

