/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io;

import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationReaderContext;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.ConfigurationSchemaVersion;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.configuration.io.PropertyReplacer;

public abstract class AbstractConfigurationReader
implements ConfigurationReader {
    private final String name;
    private final Properties properties;
    private final PropertyReplacer replacer;
    private final ConfigurationResourceResolver resolver;
    protected final NamingStrategy namingStrategy;
    private ConfigurationSchemaVersion schema;

    protected AbstractConfigurationReader(ConfigurationResourceResolver resolver, Properties properties, PropertyReplacer replacer, NamingStrategy namingStrategy) {
        URL context = resolver.getContext();
        this.name = context != null ? context.getPath() : null;
        this.resolver = resolver;
        this.properties = properties;
        this.replacer = replacer;
        this.namingStrategy = namingStrategy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConfigurationResourceResolver getResourceResolver() {
        return this.resolver;
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public ConfigurationSchemaVersion getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(ConfigurationSchemaVersion schema) {
        this.schema = schema;
    }

    @Override
    public void handleAny(ConfigurationReaderContext context) {
        this.require(ConfigurationReader.ElementType.START_ELEMENT);
        context.handleAnyElement(this);
    }

    @Override
    public void handleAttribute(ConfigurationReaderContext context, int i) {
        this.require(ConfigurationReader.ElementType.START_ELEMENT);
        context.handleAnyAttribute(this, i);
    }

    @Override
    public String getAttributeName(int index) {
        return this.getAttributeName(index, this.namingStrategy);
    }

    @Override
    public String getLocalName() {
        return this.getLocalName(this.namingStrategy);
    }

    @Override
    public String getAttributeValue(String name) {
        return this.getAttributeValue(name, this.namingStrategy);
    }

    @Override
    public Map.Entry<String, String> getMapItem(Enum<?> nameAttribute) {
        return this.getMapItem(nameAttribute.toString());
    }

    @Override
    public String[] readArray(Enum<?> outer, Enum<?> inner) {
        return this.readArray(outer.toString(), inner.toString());
    }

    protected String replaceProperties(String value) {
        return this.replacer.replaceProperties(value, this.properties);
    }
}

