/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.io.IOException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.function.SerializablePredicate;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.IdentifierFactory;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.PrimaryOwnerLocator;
import org.wildfly.clustering.ee.infinispan.affinity.AffinityIdentifierFactory;
import org.wildfly.clustering.ee.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.ee.infinispan.scheduler.PrimaryOwnerScheduler;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleLocalKeysTask;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleWithMetaDataCommand;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleWithTransientMetaDataCommand;
import org.wildfly.clustering.ee.infinispan.scheduler.SchedulerTopologyChangeListener;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.timer.IntervalTimerCreationMetaDataEntry;
import org.wildfly.clustering.ejb.infinispan.timer.ScheduleTimerCreationMetaDataEntry;
import org.wildfly.clustering.ejb.infinispan.timer.TimerCreationMetaData;
import org.wildfly.clustering.ejb.infinispan.timer.TimerCreationMetaDataKey;
import org.wildfly.clustering.ejb.infinispan.timer.TimerCreationMetaDataKeyFilter;
import org.wildfly.clustering.ejb.infinispan.timer.TimerFactory;
import org.wildfly.clustering.ejb.infinispan.timer.TimerIndex;
import org.wildfly.clustering.ejb.infinispan.timer.TimerMetaDataFactory;
import org.wildfly.clustering.ejb.infinispan.timer.TimerScheduler;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.IntervalTimerConfiguration;
import org.wildfly.clustering.ejb.timer.ScheduleTimerConfiguration;
import org.wildfly.clustering.ejb.timer.Timer;
import org.wildfly.clustering.ejb.timer.TimerManager;
import org.wildfly.clustering.ejb.timer.TimerRegistry;
import org.wildfly.clustering.infinispan.distribution.CacheLocality;
import org.wildfly.clustering.infinispan.distribution.Locality;
import org.wildfly.clustering.infinispan.distribution.SimpleLocality;
import org.wildfly.clustering.infinispan.listener.ListenerRegistration;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.server.group.Group;

public class InfinispanTimerManager<I, V>
implements TimerManager<I, TransactionBatch> {
    private final Cache<Key<I>, ?> cache;
    private final CacheProperties properties;
    private final TimerFactory<I, V> factory;
    private final Marshaller<Object, V> marshaller;
    private final IdentifierFactory<I> identifierFactory;
    private final Batcher<TransactionBatch> batcher;
    private final CommandDispatcherFactory dispatcherFactory;
    private final Group<Address> group;
    private final TimerRegistry<I> registry;
    private volatile Scheduler<I, ImmutableTimerMetaData> scheduledTimers;
    private volatile Scheduler<I, ImmutableTimerMetaData> scheduler;
    private volatile ListenerRegistration schedulerListenerRegistration;

    public InfinispanTimerManager(InfinispanTimerManagerConfiguration<I, V> config) {
        this.cache = config.getCache();
        this.properties = config.getCacheProperties();
        this.marshaller = config.getMarshaller();
        this.identifierFactory = new AffinityIdentifierFactory(config.getIdentifierFactory(), this.cache, config.getKeyAffinityServiceFactory());
        this.batcher = config.getBatcher();
        this.dispatcherFactory = config.getCommandDispatcherFactory();
        this.group = config.getGroup();
        this.factory = config.getTimerFactory();
        this.registry = config.getRegistry();
    }

    public void start() {
        Supplier<Locality> locality = () -> new CacheLocality(this.cache);
        PrimaryOwnerScheduler localScheduler = new TimerScheduler(this.factory, this, locality, Duration.ofMillis(this.cache.getCacheConfiguration().transaction().cacheStopTimeout()), this.registry);
        this.scheduledTimers = localScheduler;
        this.scheduler = this.group.isSingleton() ? localScheduler : new PrimaryOwnerScheduler(this.dispatcherFactory, this.cache.getName(), (CacheEntryScheduler)localScheduler, (Function)new PrimaryOwnerLocator(this.cache, this.group), TimerCreationMetaDataKey::new, this.properties.isTransactional() ? ScheduleWithMetaDataCommand::new : ScheduleWithTransientMetaDataCommand::new);
        TimerRegistry<I> registry = this.registry;
        ScheduleLocalKeysTask scheduleTask = new ScheduleLocalKeysTask(this.cache, (Predicate)((Object)TimerCreationMetaDataKeyFilter.INSTANCE), new Consumer<I>((TimerScheduler)localScheduler, registry){
            final /* synthetic */ TimerScheduler val$localScheduler;
            final /* synthetic */ TimerRegistry val$registry;
            {
                this.val$localScheduler = timerScheduler;
                this.val$registry = timerRegistry;
            }

            @Override
            public void accept(I id) {
                this.val$localScheduler.schedule(id);
                this.val$registry.register(id);
            }
        });
        this.schedulerListenerRegistration = new SchedulerTopologyChangeListener(this.cache, (CacheEntryScheduler)localScheduler, (BiConsumer)scheduleTask).register();
        scheduleTask.accept(new SimpleLocality(false), new CacheLocality(this.cache));
        this.identifierFactory.start();
    }

    public void stop() {
        Scheduler<I, ImmutableTimerMetaData> scheduler;
        this.identifierFactory.stop();
        ListenerRegistration registration = this.schedulerListenerRegistration;
        if (registration != null) {
            registration.close();
        }
        if ((scheduler = this.scheduler) != null) {
            scheduler.close();
        }
    }

    public Timer<I> createTimer(I id, IntervalTimerConfiguration config, Object context) {
        try {
            IntervalTimerCreationMetaDataEntry<Object> creationMetaData = new IntervalTimerCreationMetaDataEntry<Object>(this.marshaller.write(context), config);
            return this.createTimer(id, creationMetaData, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Timer<I> createTimer(I id, ScheduleTimerConfiguration config, Object context) {
        try {
            ScheduleTimerCreationMetaDataEntry<Object> creationMetaData = new ScheduleTimerCreationMetaDataEntry<Object>(this.marshaller.write(context), config, null);
            return this.createTimer(id, creationMetaData, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Timer<I> createTimer(I id, ScheduleTimerConfiguration config, Object context, Method method, int index) {
        try {
            ScheduleTimerCreationMetaDataEntry<Object> creationMetaData = new ScheduleTimerCreationMetaDataEntry<Object>(this.marshaller.write(context), config, method);
            return this.createTimer(id, creationMetaData, new TimerIndex(method, index));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Timer<I> createTimer(I id, TimerCreationMetaData<V> creationMetaData, TimerIndex index) {
        TimerMetaDataFactory<I, V> metaDataFactory = this.factory.getMetaDataFactory();
        Map.Entry entry = (Map.Entry)metaDataFactory.createValue(id, new AbstractMap.SimpleImmutableEntry<TimerCreationMetaData<V>, TimerIndex>(creationMetaData, index));
        if (entry == null) {
            return null;
        }
        ImmutableTimerMetaData metaData = metaDataFactory.createImmutableTimerMetaData(entry);
        Timer<I> timer = this.factory.createTimer(id, metaData, this, this.scheduledTimers);
        return timer;
    }

    public Timer<I> getTimer(I id) {
        TimerMetaDataFactory<I, V> metaDataFactory = this.factory.getMetaDataFactory();
        Map.Entry entry = (Map.Entry)metaDataFactory.findValue(id);
        if (entry != null) {
            ImmutableTimerMetaData metaData = metaDataFactory.createImmutableTimerMetaData(entry);
            return this.factory.createTimer(id, metaData, this, this.scheduledTimers);
        }
        return null;
    }

    public Stream<I> getActiveTimers() {
        return this.group.isSingleton() ? this.scheduledTimers.stream() : this.cache.keySet().stream().filter((SerializablePredicate)TimerCreationMetaDataKeyFilter.INSTANCE).map(Key::getId);
    }

    public Supplier<I> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public String toString() {
        return this.cache.getName();
    }
}

