/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.internal;

import java.util.List;
import java.util.function.BiConsumer;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.ast.MutationGroup;
import org.hibernate.sql.model.ast.TableMutation;

public class MutationGroupStandard
implements MutationGroup {
    private final MutationType mutationType;
    private final MutationTarget<?> mutationTarget;
    private final List<? extends TableMutation<?>> tableMutationList;

    public MutationGroupStandard(MutationType mutationType, MutationTarget<?> mutationTarget, List<? extends TableMutation<?>> tableMutationList) {
        this.mutationType = mutationType;
        this.mutationTarget = mutationTarget;
        this.tableMutationList = tableMutationList;
    }

    @Override
    public MutationType getMutationType() {
        return this.mutationType;
    }

    @Override
    public MutationTarget<?> getMutationTarget() {
        return this.mutationTarget;
    }

    @Override
    public int getNumberOfTableMutations() {
        return this.tableMutationList.size();
    }

    @Override
    public <O extends MutationOperation, M extends TableMutation<O>> M getSingleTableMutation() {
        throw new IllegalStateException("Group contains multiple table mutations : " + this.mutationTarget.getNavigableRole());
    }

    @Override
    public <O extends MutationOperation, M extends TableMutation<O>> M getTableMutation(String tableName) {
        for (int i = 0; i < this.tableMutationList.size(); ++i) {
            TableMutation<?> tableMutation = this.tableMutationList.get(i);
            if (tableMutation == null || !tableMutation.getMutatingTable().getTableName().equals(tableName)) continue;
            return (M)tableMutation;
        }
        return null;
    }

    @Override
    public <O extends MutationOperation, M extends TableMutation<O>> void forEachTableMutation(BiConsumer<Integer, M> action) {
        for (int i = 0; i < this.tableMutationList.size(); ++i) {
            action.accept(i, this.tableMutationList.get(i));
        }
    }
}

