/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.exec;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.resource.transaction.spi.DdlTransactionIsolator;
import org.hibernate.tool.schema.internal.exec.GenerationTarget;
import org.hibernate.tool.schema.spi.CommandAcceptanceException;
import org.hibernate.tool.schema.spi.ScriptSourceInput;

public class GenerationTargetToDatabase
implements GenerationTarget {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(GenerationTargetToDatabase.class);
    private final DdlTransactionIsolator ddlTransactionIsolator;
    private final boolean releaseAfterUse;
    private Statement jdbcStatement;
    private final boolean autocommit;

    public GenerationTargetToDatabase(DdlTransactionIsolator ddlTransactionIsolator) {
        this(ddlTransactionIsolator, true);
    }

    public GenerationTargetToDatabase(DdlTransactionIsolator ddlTransactionIsolator, boolean releaseAfterUse) {
        this(ddlTransactionIsolator, releaseAfterUse, true);
    }

    public GenerationTargetToDatabase(DdlTransactionIsolator ddlTransactionIsolator, boolean releaseAfterUse, boolean autocommit) {
        this.ddlTransactionIsolator = ddlTransactionIsolator;
        this.releaseAfterUse = releaseAfterUse;
        this.autocommit = autocommit;
    }

    private SqlStatementLogger getSqlStatementLogger() {
        return this.ddlTransactionIsolator.getJdbcContext().getSqlStatementLogger();
    }

    private SqlExceptionHelper getSqlExceptionHelper() {
        return this.ddlTransactionIsolator.getJdbcContext().getSqlExceptionHelper();
    }

    private Connection getIsolatedConnection() {
        return this.ddlTransactionIsolator.getIsolatedConnection(this.autocommit);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void beforeScript(ScriptSourceInput scriptSource) {
        log.executingScript(scriptSource.getScriptDescription());
    }

    @Override
    public void accept(String command) {
        this.getSqlStatementLogger().logStatement(command, FormatStyle.NONE.getFormatter());
        try {
            Statement jdbcStatement = this.jdbcStatement();
            jdbcStatement.execute(command);
            try {
                SQLWarning warnings = jdbcStatement.getWarnings();
                if (warnings != null) {
                    this.getSqlExceptionHelper().logAndClearWarnings(jdbcStatement);
                }
            }
            catch (SQLException e) {
                log.unableToLogSqlWarnings(e);
            }
        }
        catch (SQLException e) {
            throw new CommandAcceptanceException("Error executing DDL \"" + command + "\" via JDBC [" + GenerationTargetToDatabase.stripSql(e) + "]", e);
        }
    }

    private static String stripSql(SQLException e) {
        String message = e.getMessage();
        int index = message.indexOf(" SQL statement:");
        return index > 0 ? message.substring(0, index) : message;
    }

    private Statement jdbcStatement() {
        if (this.jdbcStatement == null) {
            try {
                this.jdbcStatement = this.getIsolatedConnection().createStatement();
            }
            catch (SQLException e) {
                throw this.getSqlExceptionHelper().convert(e, "Unable to create JDBC Statement for DDL execution");
            }
        }
        return this.jdbcStatement;
    }

    @Override
    public void release() {
        if (this.jdbcStatement != null) {
            try {
                this.jdbcStatement.close();
                this.jdbcStatement = null;
            }
            catch (SQLException e) {
                throw this.getSqlExceptionHelper().convert(e, "Unable to close JDBC Statement after DDL execution");
            }
        }
        if (this.releaseAfterUse) {
            this.ddlTransactionIsolator.release();
        }
    }
}

