/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.session.oob;

import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionMetaData;

public class OOBSession<L, B extends Batch>
implements Session<L>,
SessionMetaData,
SessionAttributes {
    private final SessionManager<L, B> manager;
    private final String id;
    private final L localContext;

    public OOBSession(SessionManager<L, B> manager, String id, L localContext) {
        this.manager = manager;
        this.id = id;
        this.localContext = localContext;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isValid() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            boolean bl = this.manager.readSession(this.id) != null;
            return bl;
        }
    }

    @Override
    public SessionMetaData getMetaData() {
        return this;
    }

    @Override
    public void invalidate() {
        try (Batch batch = this.manager.getBatcher().createBatch();
             Session<L> session = this.manager.findSession(this.id);){
            if (session == null) {
                throw new IllegalStateException();
            }
            session.invalidate();
        }
    }

    @Override
    public SessionAttributes getAttributes() {
        return this;
    }

    @Override
    public L getLocalContext() {
        return this.localContext;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isNew() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.readSession(this.id);
            if (session == null) {
                throw new IllegalStateException();
            }
            boolean bl = session.getMetaData().isNew();
            return bl;
        }
    }

    public boolean isExpired() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.readSession(this.id);
            if (session == null) {
                throw new IllegalStateException();
            }
            boolean bl = session.getMetaData().isExpired();
            return bl;
        }
    }

    @Override
    public Instant getCreationTime() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.readSession(this.id);
            if (session == null) {
                throw new IllegalStateException();
            }
            Instant instant = session.getMetaData().getCreationTime();
            return instant;
        }
    }

    @Override
    public Instant getLastAccessStartTime() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.readSession(this.id);
            if (session == null) {
                throw new IllegalStateException();
            }
            Instant instant = session.getMetaData().getLastAccessStartTime();
            return instant;
        }
    }

    public Instant getLastAccessTime() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.readSession(this.id);
            if (session == null) {
                throw new IllegalStateException();
            }
            Instant instant = session.getMetaData().getLastAccessTime();
            return instant;
        }
    }

    public Duration getTimeout() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.readSession(this.id);
            if (session == null) {
                throw new IllegalStateException();
            }
            Duration duration = session.getMetaData().getTimeout();
            return duration;
        }
    }

    @Override
    public void setLastAccess(Instant startTime, Instant endTime) {
        throw new IllegalStateException();
    }

    @Override
    public void setMaxInactiveInterval(Duration duration) {
        try (Batch batch = this.manager.getBatcher().createBatch();
             Session<L> session = this.manager.findSession(this.id);){
            if (session == null) {
                throw new IllegalStateException();
            }
            session.getMetaData().setMaxInactiveInterval(duration);
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.readSession(this.id);
            if (session == null) {
                throw new IllegalStateException();
            }
            Set<String> set = session.getAttributes().getAttributeNames();
            return set;
        }
    }

    @Override
    public Object getAttribute(String name) {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.readSession(this.id);
            if (session == null) {
                throw new IllegalStateException();
            }
            Object object = session.getAttributes().getAttribute(name);
            return object;
        }
    }

    @Override
    public Object removeAttribute(String name) {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Session<L> session = this.manager.findSession(this.id);
            try {
                if (session == null) {
                    throw new IllegalStateException();
                }
                Object object = session.getAttributes().removeAttribute(name);
                if (session != null) {
                    session.close();
                }
                return object;
            }
            catch (Throwable throwable) {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    @Override
    public Object setAttribute(String name, Object value) {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Session<L> session = this.manager.findSession(this.id);
            try {
                if (session == null) {
                    throw new IllegalStateException();
                }
                Object object = session.getAttributes().setAttribute(name, value);
                if (session != null) {
                    session.close();
                }
                return object;
            }
            catch (Throwable throwable) {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }
}

