/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jberet.job.model.MergeableElement;

public final class ExceptionClassFilter
extends MergeableElement
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6174512038188933722L;
    List<String> include = new ArrayList<String>();
    List<String> exclude = new ArrayList<String>();

    public List<String> getInclude() {
        return this.include;
    }

    public void setInclude(List<String> include) {
        this.include = include;
    }

    public List<String> getExclude() {
        return this.exclude;
    }

    public void setExclude(List<String> exclude) {
        this.exclude = exclude;
    }

    static void addExceptionClassTo(String exceptionClass, List<String> includeOrExcludeList) {
        String trimmed = exceptionClass.trim();
        if (!trimmed.isEmpty()) {
            includeOrExcludeList.add(trimmed);
        }
    }

    public boolean matches(Class<? extends Throwable> clazz) {
        if (this.include.isEmpty()) {
            return false;
        }
        String clazzName = clazz.getName();
        if (this.include.contains(clazzName)) {
            return true;
        }
        if (this.exclude.contains(clazzName)) {
            return false;
        }
        int shortestDistanceToInclude = this.getShortestDistance(clazz, this.include);
        if (shortestDistanceToInclude == Integer.MAX_VALUE) {
            return false;
        }
        if (shortestDistanceToInclude == 1) {
            return true;
        }
        if (this.exclude.isEmpty()) {
            return true;
        }
        return shortestDistanceToInclude < this.getShortestDistance(clazz, this.exclude);
    }

    private int getShortestDistance(Class<? extends Throwable> clazz, List<String> filterClasses) {
        int result = Integer.MAX_VALUE;
        for (String filterClass : filterClasses) {
            int distance = 0;
            boolean found = false;
            for (Class<? extends Throwable> superclass = clazz.getSuperclass(); superclass != Throwable.class && superclass != Object.class; superclass = superclass.getSuperclass()) {
                ++distance;
                if (!superclass.getName().equals(filterClass)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            if (distance == 1) {
                return distance;
            }
            if (distance >= result) continue;
            result = distance;
        }
        return result;
    }

    protected ExceptionClassFilter clone() {
        ExceptionClassFilter c = new ExceptionClassFilter();
        c.include.addAll(this.include);
        c.exclude.addAll(this.exclude);
        return c;
    }
}

