/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.StepExecution;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jberet._private.BatchLogger;
import org.jberet._private.BatchMessages;
import org.jberet.job.model.Flow;
import org.jberet.job.model.JobElement;
import org.jberet.job.model.Split;
import org.jberet.runtime.AbstractExecution;
import org.jberet.runtime.FlowExecutionImpl;
import org.jberet.runtime.context.AbstractContext;
import org.jberet.runtime.context.SplitContextImpl;
import org.jberet.runtime.runner.CompositeExecutionRunner;
import org.jberet.spi.JobTask;

public final class SplitExecutionRunner
extends CompositeExecutionRunner<SplitContextImpl>
implements JobTask {
    private final Split split;

    public SplitExecutionRunner(SplitContextImpl splitContext, CompositeExecutionRunner enclosingRunner) {
        super(splitContext, enclosingRunner);
        this.split = splitContext.getSplit();
    }

    @Override
    protected List<? extends JobElement> getJobElements() {
        return this.split.getFlows();
    }

    @Override
    public void run() {
        String next;
        boolean terminateSplit;
        block19: {
            ((SplitContextImpl)this.batchContext).setBatchStatus(BatchStatus.STARTED);
            List<Flow> flows = this.split.getFlows();
            CountDownLatch latch = new CountDownLatch(flows.size());
            terminateSplit = false;
            try {
                for (Flow flow : flows) {
                    this.runFlow(flow, latch);
                }
                long splitTimeoutSeconds = this.getSplitTimeoutSeconds();
                if (splitTimeoutSeconds > 0L) {
                    if (!latch.await(splitTimeoutSeconds, TimeUnit.SECONDS)) {
                        throw BatchMessages.MESSAGES.splitExecutionTimeout(this.split.getId(), splitTimeoutSeconds);
                    }
                } else {
                    latch.await();
                }
                List<FlowExecutionImpl> fes = ((SplitContextImpl)this.batchContext).getFlowExecutions();
                AbstractExecution failedFlow = null;
                AbstractExecution stoppedFlow = null;
                AbstractExecution endedFlow = null;
                for (int i = 0; i < fes.size(); ++i) {
                    FlowExecutionImpl flowExecution = fes.get(i);
                    if (flowExecution.getBatchStatus() == BatchStatus.FAILED) {
                        failedFlow = flowExecution;
                        break;
                    }
                    if (flowExecution.getBatchStatus() == BatchStatus.STOPPED) {
                        stoppedFlow = flowExecution;
                        continue;
                    }
                    if (flowExecution.getBatchStatus() != BatchStatus.COMPLETED || !flowExecution.isEnded()) continue;
                    endedFlow = flowExecution;
                }
                if (failedFlow != null || stoppedFlow != null || endedFlow != null) {
                    String splitExitStatus;
                    BatchStatus splitBatchStatus;
                    terminateSplit = true;
                    if (failedFlow != null) {
                        splitBatchStatus = failedFlow.getBatchStatus();
                        splitExitStatus = failedFlow.getExitStatus();
                    } else if (stoppedFlow != null) {
                        splitBatchStatus = stoppedFlow.getBatchStatus();
                        splitExitStatus = stoppedFlow.getExitStatus();
                    } else {
                        splitBatchStatus = endedFlow.getBatchStatus();
                        splitExitStatus = endedFlow.getExitStatus();
                    }
                    ((SplitContextImpl)this.batchContext).setBatchStatus(splitBatchStatus);
                    if (splitExitStatus != null) {
                        ((SplitContextImpl)this.batchContext).setExitStatus(splitExitStatus);
                    }
                    for (AbstractContext c : ((SplitContextImpl)this.batchContext).getOuterContexts()) {
                        c.setBatchStatus(splitBatchStatus);
                        if (splitExitStatus == null) continue;
                        c.setExitStatus(splitExitStatus);
                    }
                    break block19;
                }
                if (!((SplitContextImpl)this.batchContext).getBatchStatus().equals((Object)BatchStatus.STARTED)) break block19;
                ((SplitContextImpl)this.batchContext).setBatchStatus(BatchStatus.COMPLETED);
            }
            catch (Throwable e) {
                terminateSplit = true;
                BatchLogger.LOGGER.failToRunJob(e, this.jobContext.getJobName(), this.split.getId(), this.split);
                for (AbstractContext c : ((SplitContextImpl)this.batchContext).getOuterContexts()) {
                    c.setBatchStatus(BatchStatus.FAILED);
                }
            }
        }
        if (!terminateSplit && ((SplitContextImpl)this.batchContext).getBatchStatus() == BatchStatus.COMPLETED && (next = this.split.getAttributeNext()) != null) {
            List<FlowExecutionImpl> list = ((SplitContextImpl)this.batchContext).getFlowExecutions();
            StepExecution[] stepExecutions = new StepExecution[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stepExecutions[i] = list.get(i).getLastStepExecution();
            }
            this.enclosingRunner.runJobElement(next, stepExecutions);
        }
    }

    private long getSplitTimeoutSeconds() {
        String value;
        if (this.jobContext.getJobExecution().getJobParameters() != null && (value = this.jobContext.getJobExecution().getJobParameters().getProperty("jberet.split.timeout.seconds")) != null) {
            return Long.parseLong(value.trim());
        }
        if (this.jobContext.getJob().getProperties() != null && (value = this.jobContext.getJob().getProperties().get("jberet.split.timeout.seconds")) != null) {
            return Long.parseLong(value.trim());
        }
        return 0L;
    }
}

