/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons;

import java.util.function.Consumer;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.spi.InfinispanProperties;

public enum DataType {
    ENTITY("entity", "entity", DataType::noValidation),
    NATURAL_ID("naturalid", "entity", DataType::noValidation),
    COLLECTION("collection", "entity", DataType::noValidation),
    IMMUTABLE_ENTITY("immutable-entity", "entity", DataType::noValidation),
    TIMESTAMPS("timestamps", "timestamps", c -> {
        if (c.clustering().cacheMode().isInvalidation()) {
            throw DataType.log().timestampsMustNotUseInvalidation();
        }
        if (c.memory().isEvictionEnabled()) {
            throw DataType.log().timestampsMustNotUseEviction();
        }
    }),
    QUERY("query", "local-query", DataType::noValidation),
    PENDING_PUTS("pending-puts", "pending-puts", c -> {
        if (!c.isTemplate()) {
            DataType.log().pendingPutsShouldBeTemplate();
        }
        if (c.clustering().cacheMode().isClustered()) {
            throw DataType.log().pendingPutsMustNotBeClustered();
        }
        if (c.transaction().transactionMode().isTransactional()) {
            throw DataType.log().pendingPutsMustNotBeTransactional();
        }
        if (c.expiration().maxIdle() <= 0L) {
            throw DataType.log().pendingPutsMustHaveMaxIdle();
        }
    });

    private static final InfinispanMessageLogger log;
    public final String key;
    public final String defaultCacheName;
    private final Consumer<Configuration> validation;

    private static InfinispanMessageLogger log() {
        return log;
    }

    private static void noValidation(Configuration c) {
    }

    private DataType(String key, String defaultCacheName, Consumer<Configuration> validation) {
        this.key = key;
        this.defaultCacheName = defaultCacheName;
        this.validation = validation;
    }

    public void validate(Configuration configuration) {
        this.validation.accept(configuration);
    }

    static {
        log = InfinispanMessageLogger.Provider.getLog(InfinispanProperties.class);
    }
}

