/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr.plugins;

public final class PluginId
implements Comparable<PluginId> {
    final String name;
    final int major;
    final int minor;
    final String release;
    final String idString;

    public PluginId(String name, int major, int minor, String release) {
        this.name = name;
        this.major = major;
        this.minor = minor;
        this.release = release;
        StringBuffer sb = new StringBuffer(name).append(": ").append(major).append('.').append(minor);
        if (null != release) {
            sb.append('-').append(release);
        }
        this.idString = sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getRelease() {
        return this.release;
    }

    public String toString() {
        return this.idString;
    }

    @Override
    public int compareTo(PluginId o) {
        int result = this.name.compareTo(o.name);
        if (result != 0) {
            return result;
        }
        result = this.major - o.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - o.minor;
        if (result != 0) {
            return result;
        }
        if (null != this.release) {
            return this.release.compareTo(o.release);
        }
        return result;
    }
}

