/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.common.function.ExceptionConsumer;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionObjIntConsumer;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.common.function.ExceptionToIntBiFunction;
import org.wildfly.common.function.ExceptionToIntFunction;
import org.wildfly.transaction.TransactionPermission;
import org.wildfly.transaction.client.AssociationListener;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.SynchronizationException;
import org.wildfly.transaction.client._private.Log;

public abstract class AbstractTransaction
implements Transaction {
    private static final TransactionPermission ASSOCIATION_LISTENER_PERMISSION = TransactionPermission.forName("registerAssociationListener");
    private static final Object RB_EX_KEY = new Object();
    private final Object outflowLock = new Object();
    private final long start = System.nanoTime();
    final List<AssociationListener> associationListeners = new CopyOnWriteArrayList<AssociationListener>();

    AbstractTransaction() {
    }

    abstract void registerInterposedSynchronization(Synchronization var1) throws IllegalStateException;

    public abstract Object getResource(Object var1) throws NullPointerException;

    public abstract void putResource(Object var1, Object var2) throws NullPointerException;

    public abstract Object putResourceIfAbsent(Object var1, Object var2) throws IllegalArgumentException;

    abstract Object getKey();

    boolean getRollbackOnly() {
        try {
            return this.getStatus() == 1;
        }
        catch (SystemException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        List appearing;
        List<Object> list = (ArrayList<RollbackException>)this.getResource(RB_EX_KEY);
        if (list == null && (appearing = (List)this.putResourceIfAbsent(RB_EX_KEY, list = new ArrayList<RollbackException>())) != null) {
            list = appearing;
        }
        ArrayList<RollbackException> arrayList = list;
        synchronized (arrayList) {
            list.add(Log.log.markedRollbackOnly());
        }
    }

    void addRollbackExceptions(Exception ex) {
        List list = (List)this.getResource(RB_EX_KEY);
        if (list != null) {
            for (Throwable throwable : list) {
                ex.addSuppressed(throwable);
            }
        }
    }

    abstract void suspend() throws SystemException;

    void notifyAssociationListeners(boolean associated) {
        for (AssociationListener associationListener : this.associationListeners) {
            try {
                associationListener.associationChanged(this, associated);
            }
            catch (Throwable t) {
                Log.log.tracef(t, "An association listener %s threw an exception on transaction %s", associationListener, this);
            }
        }
    }

    abstract void resume() throws SystemException;

    abstract void verifyAssociation();

    public abstract int getTransactionTimeout();

    public final int getEstimatedRemainingTime() {
        long elapsed = System.nanoTime() - this.start;
        int transactionTimeout = this.getTransactionTimeout();
        return transactionTimeout - (int)Math.min(Math.max(elapsed, 0L) / 1000000000L, (long)transactionTimeout);
    }

    public <T> T getProviderInterface(Class<T> providerInterfaceType) {
        return null;
    }

    public void registerAssociationListener(AssociationListener associationListener) {
        Assert.checkNotNullParam((String)"associationListener", (Object)associationListener);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)ASSOCIATION_LISTENER_PERMISSION));
        }
        this.associationListeners.add(associationListener);
    }

    public abstract void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException;

    abstract void commitAndDissociate() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException;

    public abstract void rollback() throws IllegalStateException, SystemException;

    abstract void rollbackAndDissociate() throws IllegalStateException, SystemException;

    private static void doNothing() {
    }

    private static SysExTry whileSuspended() throws SystemException {
        ContextTransactionManager tm = ContextTransactionManager.INSTANCE;
        AbstractTransaction suspended = tm.suspend();
        return suspended == null ? AbstractTransaction::doNothing : () -> tm.resume(suspended);
    }

    private static SysExTry whileResumed(AbstractTransaction transaction) throws SystemException {
        if (transaction == null) {
            return AbstractTransaction::doNothing;
        }
        ContextTransactionManager tm = ContextTransactionManager.INSTANCE;
        tm.resume(transaction);
        return tm::suspend;
    }

    public <T, U, R, E extends Exception> R performFunction(ExceptionBiFunction<T, U, R, E> function, T param1, U param2) throws E, SystemException {
        ContextTransactionManager tm = ContextTransactionManager.INSTANCE;
        if (Objects.equals(tm.getStateRef().get().transaction, this)) {
            return (R)function.apply(param1, param2);
        }
        try (SysExTry ignored = AbstractTransaction.whileSuspended();){
            Object object;
            block13: {
                SysExTry ignored2 = AbstractTransaction.whileResumed(this);
                try {
                    object = function.apply(param1, param2);
                    if (ignored2 == null) break block13;
                }
                catch (Throwable throwable) {
                    if (ignored2 != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored2.close();
            }
            return (R)object;
        }
    }

    public <T, R, E extends Exception> R performFunction(ExceptionFunction<T, R, E> function, T param) throws E, SystemException {
        return this.performFunction(ExceptionFunction::apply, function, param);
    }

    public <R, E extends Exception> R performSupplier(ExceptionSupplier<R, E> function) throws E, SystemException {
        return this.performFunction(ExceptionSupplier::get, function);
    }

    public <T, E extends Exception> void performConsumer(ExceptionObjIntConsumer<T, E> consumer, T param1, int param2) throws E, SystemException {
        ContextTransactionManager tm = ContextTransactionManager.INSTANCE;
        if (Objects.equals(tm.getStateRef().get().transaction, this)) {
            consumer.accept(param1, param2);
            return;
        }
        try (SysExTry ignored = AbstractTransaction.whileSuspended();
             SysExTry ignored2 = AbstractTransaction.whileResumed(this);){
            consumer.accept(param1, param2);
        }
    }

    public <T, U, E extends Exception> void performConsumer(ExceptionBiConsumer<T, U, E> consumer, T param1, U param2) throws E, SystemException {
        ContextTransactionManager tm = ContextTransactionManager.INSTANCE;
        if (Objects.equals(tm.getStateRef().get().transaction, this)) {
            consumer.accept(param1, param2);
            return;
        }
        try (SysExTry ignored = AbstractTransaction.whileSuspended();
             SysExTry ignored2 = AbstractTransaction.whileResumed(this);){
            consumer.accept(param1, param2);
        }
    }

    public <T, E extends Exception> void performConsumer(ExceptionConsumer<T, E> consumer, T param) throws E, SystemException {
        this.performConsumer(ExceptionConsumer::accept, consumer, param);
    }

    public <T, U, E extends Exception> int performToIntFunction(ExceptionToIntBiFunction<T, U, E> function, T param1, U param2) throws E, SystemException {
        ContextTransactionManager tm = ContextTransactionManager.INSTANCE;
        if (Objects.equals(tm.getStateRef().get().transaction, this)) {
            return function.apply(param1, param2);
        }
        try (SysExTry ignored = AbstractTransaction.whileSuspended();){
            int n;
            block13: {
                SysExTry ignored2 = AbstractTransaction.whileResumed(this);
                try {
                    n = function.apply(param1, param2);
                    if (ignored2 == null) break block13;
                }
                catch (Throwable throwable) {
                    if (ignored2 != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored2.close();
            }
            return n;
        }
    }

    public <T, E extends Exception> int performToIntFunction(ExceptionToIntFunction<T, E> function, T param) throws E, SystemException {
        return this.performToIntFunction(ExceptionToIntFunction::apply, function, param);
    }

    public <E extends Exception> void performAction(ExceptionRunnable<E> action) throws E, SystemException {
        this.performConsumer(ExceptionRunnable::run, action);
    }

    Object getOutflowLock() {
        return this.outflowLock;
    }

    abstract boolean importBacking() throws SystemException;

    abstract void unimportBacking();

    final class AssociatingSynchronization
    implements Synchronization {
        private final Synchronization sync;

        AssociatingSynchronization(Synchronization sync) {
            this.sync = sync;
        }

        public void beforeCompletion() {
            block6: {
                try {
                    if (AbstractTransaction.this.importBacking()) {
                        try {
                            this.sync.beforeCompletion();
                            break block6;
                        }
                        finally {
                            AbstractTransaction.this.unimportBacking();
                        }
                    }
                    AbstractTransaction.this.performConsumer(Synchronization::beforeCompletion, this.sync);
                }
                catch (SystemException e) {
                    throw new SynchronizationException(e);
                }
            }
        }

        public void afterCompletion(int status) {
            block6: {
                try {
                    if (AbstractTransaction.this.importBacking()) {
                        try {
                            this.sync.afterCompletion(status);
                            break block6;
                        }
                        finally {
                            AbstractTransaction.this.unimportBacking();
                        }
                    }
                    AbstractTransaction.this.performConsumer(Synchronization::afterCompletion, this.sync, status);
                }
                catch (SystemException e) {
                    throw new SynchronizationException(e);
                }
            }
        }
    }

    static interface SysExTry
    extends AutoCloseable {
        @Override
        public void close() throws SystemException;
    }
}

